/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.line;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.ConnectLinesGrid;
import boofcv.alg.feature.detect.line.LineImageOps;
import boofcv.alg.feature.detect.line.gridline.Edgel;
import boofcv.alg.feature.detect.line.gridline.GridLineModelDistance;
import boofcv.alg.feature.detect.line.gridline.GridLineModelFitter;
import boofcv.alg.feature.detect.line.gridline.ImplGridRansacLineDetector_F32;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.feature.ImageLinePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.MatrixOfList;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.fitting.line.ModelManagerLinePolar2D_F32;
import georegression.struct.line.LinePolar2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class VisualizeLineRansac<I extends ImageGray, D extends ImageGray> {
    Class<I> imageType;
    Class<D> derivType;

    public VisualizeLineRansac(Class<I> imageType, Class<D> derivType) {
        this.imageType = imageType;
        this.derivType = derivType;
    }

    public void process(BufferedImage image) {
        int regionSize = 40;
        I input = GeneralizedImageOps.createSingleBand(this.imageType, image.getWidth(), image.getHeight());
        D derivX = GeneralizedImageOps.createSingleBand(this.derivType, image.getWidth(), image.getHeight());
        D derivY = GeneralizedImageOps.createSingleBand(this.derivType, image.getWidth(), image.getHeight());
        GrayF32 edgeIntensity = new GrayF32(((ImageGray)input).width, ((ImageGray)input).height);
        GrayF32 suppressed = new GrayF32(((ImageGray)input).width, ((ImageGray)input).height);
        GrayF32 orientation = new GrayF32(((ImageGray)input).width, ((ImageGray)input).height);
        GrayS8 direction = new GrayS8(((ImageGray)input).width, ((ImageGray)input).height);
        GrayU8 detected = new GrayU8(((ImageGray)input).width, ((ImageGray)input).height);
        ModelManagerLinePolar2D_F32 manager = new ModelManagerLinePolar2D_F32();
        GridLineModelDistance distance = new GridLineModelDistance(2.3561945f);
        GridLineModelFitter fitter = new GridLineModelFitter(2.3561945f);
        Ransac matcher = new Ransac(123123L, (ModelManager)manager, (ModelGenerator)fitter, (DistanceFromModel)distance, 25, 1.0);
        ImageGradient<I, D> gradient = FactoryDerivative.sobel(this.imageType, this.derivType);
        System.out.println("Image width " + ((ImageGray)input).width + " height " + ((ImageGray)input).height);
        ConvertBufferedImage.convertFromSingle(image, input, this.imageType);
        gradient.process(input, derivX, derivY);
        GGradientToEdgeFeatures.intensityAbs(derivX, derivY, edgeIntensity);
        GThresholdImageOps.threshold(edgeIntensity, detected, 30.0, false);
        ImplGridRansacLineDetector_F32 alg = new ImplGridRansacLineDetector_F32(40, 10, (ModelMatcher<LinePolar2D_F32, Edgel>)matcher);
        alg.process((GrayF32)derivX, (GrayF32)derivY, detected);
        MatrixOfList<LineSegment2D_F32> gridLine = alg.getFoundLines();
        ConnectLinesGrid connect = new ConnectLinesGrid(0.031415926535897934, 1.0, 8.0);
        List<LineSegment2D_F32> found = gridLine.createSingleList();
        System.out.println("size = " + found.size());
        LineImageOps.mergeSimilar(found, 0.09424778f, 5.0f);
        System.out.println("after size = " + found.size());
        ImageLinePanel gui = new ImageLinePanel();
        gui.setBackground(image);
        gui.setLineSegments(found);
        gui.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        BufferedImage renderedBinary = VisualizeBinaryData.renderBinary(detected, false, null);
        ShowImages.showWindow(renderedBinary, "Detected Edges");
        ShowImages.showWindow(gui, "Detected Lines");
    }

    public static void main(String[] args) {
        VisualizeLineRansac<GrayF32, GrayF32> app = new VisualizeLineRansac<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        app.process(UtilImageIO.loadImage(UtilIO.pathExample("lines_indoors.jpg")));
    }
}

