/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.intensity;

import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.intensity.WrapperFastCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperHessianBlobIntensity;
import boofcv.abst.feature.detect.intensity.WrapperKitRosCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperMedianCornerIntensity;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.misc.ImageStatistics;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class IntensityPointFeatureApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel {
    ImagePanel gui;
    BufferedImage input;
    BufferedImage temp;
    T workImage;
    Class<T> imageType;
    AnyImageDerivative<T, D> deriv;
    boolean processImage = false;

    public IntensityPointFeatureApp(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        boolean isInteger = !GeneralizedImageOps.isFloatingPoint(imageType);
        this.deriv = new AnyImageDerivative<T, D>(GradientThree.getKernelX(isInteger), imageType, derivType);
        this.addAlgorithm(0, "Laplacian", new WrapperHessianBlobIntensity(HessianBlobIntensity.Type.TRACE, derivType));
        this.addAlgorithm(0, "Hessian Det", new WrapperHessianBlobIntensity(HessianBlobIntensity.Type.DETERMINANT, derivType));
        this.addAlgorithm(0, "Harris", new WrapperGradientCornerIntensity(FactoryIntensityPointAlg.harris(2, 0.4f, false, derivType)));
        this.addAlgorithm(0, "Harris Weighted", new WrapperGradientCornerIntensity(FactoryIntensityPointAlg.harris(2, 0.4f, true, derivType)));
        this.addAlgorithm(0, "Shi Tomasi", new WrapperGradientCornerIntensity(FactoryIntensityPointAlg.shiTomasi(2, false, derivType)));
        this.addAlgorithm(0, "Shi Tomasi Weighted", new WrapperGradientCornerIntensity(FactoryIntensityPointAlg.shiTomasi(2, true, derivType)));
        this.addAlgorithm(0, "FAST", new WrapperFastCornerIntensity(FactoryIntensityPointAlg.fast(5, 11, imageType)));
        this.addAlgorithm(0, "KitRos", new WrapperKitRosCornerIntensity(derivType));
        this.addAlgorithm(0, "Median", new WrapperMedianCornerIntensity(FactoryBlurFilter.median(imageType, 2), imageType));
        this.gui = new ImagePanel();
        this.setMainGUI(this.gui);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.workImage == null) {
            return;
        }
        GeneralFeatureIntensity intensity = (GeneralFeatureIntensity)cookie;
        this.deriv.setInput(this.workImage);
        D derivX = this.deriv.getDerivative(true);
        D derivY = this.deriv.getDerivative(false);
        D derivXX = this.deriv.getDerivative(true, true);
        D derivYY = this.deriv.getDerivative(false, false);
        D derivXY = this.deriv.getDerivative(true, false);
        intensity.process(this.workImage, derivX, derivY, derivXX, derivYY, derivXY);
        GrayF32 featureImg = intensity.getIntensity();
        VisualizeImageData.colorizeSign((ImageGray)featureImg, this.temp, (double)ImageStatistics.maxAbs(featureImg));
        this.gui.setBufferedImage(this.temp);
        this.gui.repaint();
        this.gui.requestFocusInWindow();
    }

    public void process(final BufferedImage input) {
        this.setInputImage(input);
        this.input = input;
        this.workImage = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        this.temp = new BufferedImage(((ImageGray)this.workImage).width, ((ImageGray)this.workImage).height, 4);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IntensityPointFeatureApp.this.setPreferredSize(new Dimension(input.getWidth(), input.getHeight()));
                IntensityPointFeatureApp.this.processImage = true;
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processImage;
    }

    public static void main(String[] args) {
        IntensityPointFeatureApp<GrayU8, GrayS16> app = new IntensityPointFeatureApp<GrayU8, GrayS16>(GrayU8.class, GrayS16.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Feature Intensity", true);
    }
}

