/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.extract;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.demonstrations.feature.detect.extract.GeneralExtractConfigPanel;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPoint;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.FancyInterestPointRender;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I16;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CompareFeatureExtractorApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements GeneralExtractConfigPanel.Listener {
    T grayImage;
    Class<T> imageType;
    GeneralExtractConfigPanel configPanel;
    boolean processImage = false;
    BufferedImage input;
    BufferedImage intensityImage;
    BufferedImage workImage;
    AnyImageDerivative<T, D> deriv;
    GeneralFeatureIntensity<T, D> intensityAlg;
    int minSeparation = 5;
    int viewImage = 2;
    int radius = 2;
    int numFeatures = 200;
    float thresholdFraction = 0.1f;
    FancyInterestPointRender render = new FancyInterestPointRender();
    ImagePanel imagePanel;

    public CompareFeatureExtractorApp(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        this.addAlgorithm(0, "Harris", FactoryIntensityPoint.harris(this.radius, 0.04f, false, imageType));
        this.addAlgorithm(0, "KLT", FactoryIntensityPoint.shiTomasi(this.radius, false, derivType));
        this.addAlgorithm(0, "FAST", FactoryIntensityPoint.fast(5, 11, derivType));
        this.addAlgorithm(0, "KitRos", FactoryIntensityPoint.kitros(derivType));
        this.addAlgorithm(0, "Laplace Det", FactoryIntensityPoint.hessian(HessianBlobIntensity.Type.DETERMINANT, derivType));
        this.addAlgorithm(0, "Laplace Trace", FactoryIntensityPoint.hessian(HessianBlobIntensity.Type.TRACE, derivType));
        this.deriv = GImageDerivativeOps.createAnyDerivatives(DerivativeType.SOBEL, imageType, derivType);
        JPanel gui = new JPanel();
        gui.setLayout(new BorderLayout());
        this.imagePanel = new ImagePanel();
        this.configPanel = new GeneralExtractConfigPanel();
        this.configPanel.setThreshold(this.thresholdFraction);
        this.configPanel.setFeatureSeparation(this.minSeparation);
        this.configPanel.setImageIndex(this.viewImage);
        this.configPanel.setListener(this);
        gui.add((Component)this.configPanel, "West");
        gui.add((Component)this.imagePanel, "Center");
        this.setMainGUI(gui);
    }

    public void process(BufferedImage input) {
        this.input = input;
        this.grayImage = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        this.workImage = new BufferedImage(input.getWidth(), input.getHeight(), 4);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompareFeatureExtractorApp.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.input == null) {
            return;
        }
        this.intensityAlg = (GeneralFeatureIntensity)cookie;
        this.doProcess();
    }

    private synchronized void doProcess() {
        this.deriv.setInput(this.grayImage);
        D derivX = this.deriv.getDerivative(true);
        D derivY = this.deriv.getDerivative(false);
        D derivXX = this.deriv.getDerivative(true, true);
        D derivYY = this.deriv.getDerivative(false, false);
        D derivXY = this.deriv.getDerivative(true, false);
        this.intensityAlg.process(this.grayImage, derivX, derivY, derivXX, derivYY, derivXY);
        GrayF32 intensity = this.intensityAlg.getIntensity();
        this.intensityImage = VisualizeImageData.colorizeSign((ImageGray)this.intensityAlg.getIntensity(), null, (double)ImageStatistics.maxAbs(intensity));
        float max = ImageStatistics.maxAbs(intensity);
        float threshold = max * this.thresholdFraction;
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(this.minSeparation, threshold, this.radius, true));
        GeneralFeatureDetector<T, D> detector = new GeneralFeatureDetector<T, D>(this.intensityAlg, extractor);
        detector.setMaxFeatures(this.numFeatures);
        detector.process(this.grayImage, derivX, derivY, derivXX, derivYY, derivXY);
        QueueCorner foundCorners = detector.getMaximums();
        this.render.reset();
        for (int i = 0; i < foundCorners.size(); ++i) {
            Point2D_I16 p = (Point2D_I16)foundCorners.get(i);
            this.render.addPoint(p.x, p.y, 3, Color.RED);
        }
        Graphics2D g2 = this.workImage.createGraphics();
        g2.drawImage(this.input, 0, 0, ((ImageGray)this.grayImage).width, ((ImageGray)this.grayImage).height, null);
        this.render.draw(g2);
        this.drawImage();
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processImage;
    }

    @Override
    public void changeImage(int index) {
        this.viewImage = index;
        this.drawImage();
    }

    private void drawImage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (CompareFeatureExtractorApp.this.viewImage) {
                    case 0: {
                        CompareFeatureExtractorApp.this.imagePanel.setBufferedImage(CompareFeatureExtractorApp.this.input);
                        break;
                    }
                    case 1: {
                        CompareFeatureExtractorApp.this.imagePanel.setBufferedImage(CompareFeatureExtractorApp.this.intensityImage);
                        break;
                    }
                    case 2: {
                        CompareFeatureExtractorApp.this.imagePanel.setBufferedImage(CompareFeatureExtractorApp.this.workImage);
                    }
                }
                BufferedImage b = CompareFeatureExtractorApp.this.imagePanel.getImage();
                CompareFeatureExtractorApp.this.imagePanel.setPreferredSize(new Dimension(b.getWidth(), b.getHeight()));
                CompareFeatureExtractorApp.this.imagePanel.repaint();
                CompareFeatureExtractorApp.this.processImage = true;
            }
        });
    }

    @Override
    public synchronized void changeFeatureSeparation(int radius) {
        this.minSeparation = radius;
        this.doProcess();
    }

    @Override
    public synchronized void changeThreshold(double value) {
        this.thresholdFraction = (float)value;
        this.doProcess();
    }

    @Override
    public synchronized void changeNumFeatures(int total) {
        this.numFeatures = total;
        this.doProcess();
    }

    public static void main(String[] args) {
        CompareFeatureExtractorApp<GrayF32, GrayF32> app = new CompareFeatureExtractorApp<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Feature Extraction", true);
        System.out.println("Done");
    }
}

