/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect;

import boofcv.alg.filter.basic.GGrayImageOps;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.GPixelMath;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.struct.image.ImageGray;
import java.util.Random;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageCorruptPanel
extends StandardAlgConfigPanel
implements ChangeListener {
    Random rand = new Random(8383L);
    JSpinner noiseLevel = new JSpinner(new SpinnerNumberModel(this.valueNoise, 0.0, 100.0, 5.0));
    JSpinner lightScale;
    JSpinner lightOffset;
    Listener listener;
    double valueNoise = 0.0;
    double valueScale = 1.0;
    double valueOffset = 0.0;

    public ImageCorruptPanel() {
        this.noiseLevel.addChangeListener(this);
        this.noiseLevel.setMaximumSize(this.noiseLevel.getPreferredSize());
        this.lightScale = new JSpinner(new SpinnerNumberModel(this.valueScale, 0.5, 2.0, 0.1));
        this.lightScale.addChangeListener(this);
        this.lightScale.setMaximumSize(this.lightScale.getPreferredSize());
        this.lightOffset = new JSpinner(new SpinnerNumberModel(this.valueOffset, -30.0, 30.0, 5.0));
        this.lightOffset.addChangeListener(this);
        this.lightOffset.setMaximumSize(this.lightOffset.getPreferredSize());
        this.addLabeled(this.noiseLevel, "Noise", this);
        this.addLabeled(this.lightScale, "Light Scale", this);
        this.addLabeled(this.lightOffset, "Light Offset", this);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.valueNoise = ((Number)this.noiseLevel.getValue()).doubleValue();
        this.valueScale = ((Number)this.lightScale.getValue()).doubleValue();
        this.valueOffset = ((Number)this.lightOffset.getValue()).doubleValue();
        if (this.listener != null) {
            this.listener.corruptImageChange();
        }
    }

    public <T extends ImageGray> void corruptImage(T original, T corrupted) {
        GGrayImageOps.stretch(original, this.valueScale, this.valueOffset, 255.0, corrupted);
        GImageMiscOps.addGaussian(corrupted, this.rand, this.valueNoise, 0.0, 255.0);
        GPixelMath.boundImage(corrupted, 0.0, 255.0);
    }

    public static interface Listener {
        public void corruptImageChange();
    }
}

