/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.describe;

import boofcv.alg.feature.dense.DescribeDenseHogAlg;
import boofcv.demonstrations.feature.describe.ControlHogPanel;
import boofcv.demonstrations.feature.describe.VisualizeHogCells;
import boofcv.factory.feature.dense.ConfigDenseHoG;
import boofcv.factory.feature.dense.FactoryDescribeImageDenseAlg;
import boofcv.gui.DemonstrationBase;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class VisualizeImageHogApp<T extends ImageBase>
extends DemonstrationBase<T> {
    DescribeDenseHogAlg<T, ?> hog;
    VisualizeHogCells visualizers;
    ImagePanel imagePanel = new ImagePanel();
    BufferedImage work;
    Object lock = new Object();
    ControlHogPanel control = new ControlHogPanel(this);
    boolean showInput = false;

    public VisualizeImageHogApp(List<String> exampleInputs, ImageType<T> imageType) {
        super(exampleInputs, imageType);
        this.createHoG(imageType);
        this.visualizers = new VisualizeHogCells(this.hog);
        this.visualizers.setShowLog(this.control.doShowLog);
        this.visualizers.setLocalMax(this.control.doShowLocal);
        this.visualizers.setShowGrid(this.control.doShowGrid);
        this.add((Component)this.imagePanel, "Center");
        this.add((Component)this.control, "West");
        this.imagePanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int row = e.getY() / VisualizeImageHogApp.this.hog.getWidthCell();
                int col = e.getX() / VisualizeImageHogApp.this.hog.getWidthCell();
                if (row >= 0 && col >= 0 && row < VisualizeImageHogApp.this.hog.getCellRows() && col < VisualizeImageHogApp.this.hog.getCellCols()) {
                    DescribeDenseHogAlg.Cell c = VisualizeImageHogApp.this.hog.getCell(row, col);
                    System.out.print("Cell[" + row + " , " + col + "] histogram =");
                    for (int i = 0; i < c.histogram.length; ++i) {
                        System.out.print("  " + c.histogram[i]);
                    }
                    System.out.println();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void createHoG(ImageType<T> imageType) {
        ConfigDenseHoG config = new ConfigDenseHoG();
        config.widthCell = this.control.cellWidth;
        config.orientationBins = this.control.histogram;
        this.hog = FactoryDescribeImageDenseAlg.hog(config, imageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processImage(BufferedImage buffered, T input) {
        Object object = this.lock;
        synchronized (object) {
            this.hog.setInput(input);
            this.hog.process();
            this.work = this.visualizers.createOutputBuffered(this.work);
            Graphics2D g2 = this.work.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, this.work.getWidth(), this.work.getHeight());
            this.visualizers.render(g2);
            if (this.showInput) {
                g2.drawImage(buffered, 0, 0, buffered.getWidth() / 5, buffered.getHeight() / 5, null);
            }
        }
        this.imagePanel.setBufferedImage(this.work);
        this.imagePanel.setPreferredSize(new Dimension(this.work.getWidth(), this.work.getHeight()));
        this.imagePanel.setMinimumSize(new Dimension(this.work.getWidth(), this.work.getHeight()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCellWidth(int width) {
        Object object = this.lock;
        synchronized (object) {
            this.hog.setWidthCell(width);
            this.reprocessSingleImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistogram(int histogram) {
        Object object = this.lock;
        synchronized (object) {
            this.createHoG(this.imageType);
            this.visualizers.setHoG(this.hog);
            this.reprocessSingleImage();
        }
    }

    public void setShowGrid(boolean showGrid) {
        this.visualizers.showGrid = showGrid;
        this.reprocessSingleImage();
    }

    public void setShowLocal(boolean show) {
        this.visualizers.localMax = show;
        this.reprocessSingleImage();
    }

    public void setShowLog(boolean show) {
        this.visualizers.setShowLog(show);
        this.reprocessSingleImage();
    }

    public void setShowInput(boolean show) {
        this.showInput = show;
        this.reprocessSingleImage();
    }

    public static void main(String[] args) {
        ArrayList<String> examples = new ArrayList<String>();
        examples.add(UtilIO.pathExample("shapes/shapes01.png"));
        examples.add(UtilIO.pathExample("shapes/shapes02.png"));
        examples.add(UtilIO.pathExample("shapes/concave01.jpg"));
        examples.add(UtilIO.pathExample("particles01.jpg"));
        ImageType<GrayU8> imageType = ImageType.single(GrayU8.class);
        VisualizeImageHogApp<GrayU8> app = new VisualizeImageHogApp<GrayU8>(examples, imageType);
        app.openFile(new File((String)examples.get(0)));
        app.waitUntilDoneProcessing();
        ShowImages.showWindow(app, "Hog Descriptor Cell Visualization", true);
    }
}

