/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.describe;

import boofcv.alg.feature.dense.DescribeDenseHogAlg;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;

public class VisualizeHogCells {
    DescribeDenseHogAlg<?, ?> hog;
    Color[] colors;
    float[] cos;
    float[] sin;
    boolean localMax = false;
    boolean showGrid = false;

    public VisualizeHogCells(DescribeDenseHogAlg<?, ?> hog) {
        this.setHoG(hog);
    }

    public synchronized void setHoG(DescribeDenseHogAlg<?, ?> hog) {
        this.hog = hog;
        int numAngles = hog.getOrientationBins();
        this.cos = new float[numAngles];
        this.sin = new float[numAngles];
        for (int i = 0; i < numAngles; ++i) {
            double theta = Math.PI * ((double)i + 0.5) / (double)numAngles;
            this.cos[i] = (float)Math.cos(theta);
            this.sin[i] = (float)Math.sin(theta);
        }
    }

    public BufferedImage createOutputBuffered(BufferedImage input) {
        int cell = this.hog.getWidthCell();
        int rows = this.hog.getCellRows();
        int cols = this.hog.getCellCols();
        int width = cell * cols;
        int height = cell * rows;
        if (input == null || input.getWidth() != width || input.getHeight() != height) {
            return new BufferedImage(width, height, 1);
        }
        return input;
    }

    public synchronized void render(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.showGrid) {
            int i;
            int cell = this.hog.getWidthCell();
            int rows = this.hog.getCellRows();
            int cols = this.hog.getCellCols();
            int width = cell * cols;
            int height = cell * rows;
            g2.setColor(new Color(150, 150, 0));
            g2.setStroke(new BasicStroke(1.0f));
            for (i = 0; i < rows; ++i) {
                g2.drawLine(0, i * cell, width, i * cell);
            }
            for (i = 0; i < cols; ++i) {
                g2.drawLine(i * cell, 0, i * cell, height);
            }
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        if (this.localMax) {
            this.local(g2);
        } else {
            this.global(g2);
        }
    }

    private void local(Graphics2D g2) {
        int cell = this.hog.getWidthCell();
        int rows = this.hog.getCellRows();
        int cols = this.hog.getCellCols();
        int width = cell * cols;
        int height = cell * rows;
        int numAngles = this.hog.getOrientationBins();
        float r = cell / 2 - 1;
        Line2D.Float line = new Line2D.Float();
        for (int y = 0; y < height; y += cell) {
            float c_y = (float)y + r;
            for (int x = 0; x < width; x += cell) {
                int i;
                DescribeDenseHogAlg.Cell c = this.hog.getCell(y / cell, x / cell);
                float c_x = (float)x + r;
                float maxValue = 0.0f;
                for (i = 0; i < c.histogram.length; ++i) {
                    maxValue = Math.max(maxValue, c.histogram[i]);
                }
                for (i = 0; i < numAngles; ++i) {
                    int a = (int)(255.0f * c.histogram[i] / maxValue + 0.5f);
                    g2.setColor(this.colors[a]);
                    float x0 = c_x - r * this.cos[i];
                    float x1 = c_x + r * this.cos[i];
                    float y0 = c_y - r * this.sin[i];
                    float y1 = c_y + r * this.sin[i];
                    line.setLine(x0, y0, x1, y1);
                    g2.draw(line);
                }
            }
        }
    }

    private void global(Graphics2D g2) {
        int cell = this.hog.getWidthCell();
        int rows = this.hog.getCellRows();
        int cols = this.hog.getCellCols();
        int width = cell * cols;
        int height = cell * rows;
        int numAngles = this.hog.getOrientationBins();
        float r = cell / 2;
        float foo = cell / 2 - 2;
        float maxValue = 0.0f;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                DescribeDenseHogAlg.Cell c = this.hog.getCell(y, x);
                for (int i = 0; i < numAngles; ++i) {
                    maxValue = Math.max(maxValue, c.histogram[i]);
                }
            }
        }
        Line2D.Float line = new Line2D.Float();
        for (int y = 0; y < height; y += cell) {
            float c_y = (float)y + r;
            for (int x = 0; x < width; x += cell) {
                DescribeDenseHogAlg.Cell c = this.hog.getCell(y / cell, x / cell);
                float c_x = (float)x + r;
                for (int i = 0; i < numAngles; ++i) {
                    int a = (int)(255.0f * c.histogram[i] / maxValue + 0.5f);
                    g2.setColor(this.colors[a]);
                    float x0 = c_x - foo * this.cos[i];
                    float x1 = c_x + foo * this.cos[i];
                    float y0 = c_y - foo * this.sin[i];
                    float y1 = c_y + foo * this.sin[i];
                    line.setLine(x0, y0, x1, y1);
                    g2.draw(line);
                }
            }
        }
    }

    public boolean isLocalMax() {
        return this.localMax;
    }

    public void setLocalMax(boolean localMax) {
        this.localMax = localMax;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public void setShowLog(boolean logIntensity) {
        Color[] colors = new Color[256];
        if (logIntensity) {
            double k = 255.0 / Math.log(255.0);
            for (int i = 0; i < colors.length; ++i) {
                int v = (int)(k * Math.log(i + 1));
                colors[i] = new Color(v, v, v);
            }
        } else {
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new Color(i, i, i);
            }
        }
        this.colors = colors;
    }
}

