/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.describe;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.describe.ConvertTupleDesc;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.describe.DescribeRegionPointConvert;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryConvertTupleDesc;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.gui.feature.AssociationPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class CompareConvertedDescriptionsApp {
    public static <TD extends TupleDesc> void visualize(String title, BufferedImage image1, BufferedImage image2, InterestPointDetector<GrayF32> detector, DescribeRegionPoint<GrayF32, TD> describe, ScoreAssociation<TD> scorer) {
        AssociateDescription<TD> assoc = FactoryAssociation.greedy(scorer, Double.MAX_VALUE, false);
        ArrayList<Point2D_F64> locationSrc = new ArrayList<Point2D_F64>();
        ArrayList<Point2D_F64> locationDst = new ArrayList<Point2D_F64>();
        GrayF32 input1 = ConvertBufferedImage.convertFrom(image1, (GrayF32)null);
        GrayF32 input2 = ConvertBufferedImage.convertFrom(image2, (GrayF32)null);
        FastQueue<TD> listSrc = CompareConvertedDescriptionsApp.describeImage(input1, detector, describe, locationSrc);
        FastQueue<TD> listDst = CompareConvertedDescriptionsApp.describeImage(input2, detector, describe, locationDst);
        assoc.setSource(listSrc);
        assoc.setDestination(listDst);
        assoc.associate();
        FastQueue<AssociatedIndex> matches = assoc.getMatches();
        AssociationPanel panel = new AssociationPanel(20);
        panel.setImages(image1, image2);
        panel.setAssociation(locationSrc, locationDst, matches);
        ShowImages.showWindow(panel, title);
    }

    public static <TD extends TupleDesc> FastQueue<TD> describeImage(GrayF32 input, InterestPointDetector<GrayF32> detector, DescribeRegionPoint<GrayF32, TD> describe, List<Point2D_F64> location) {
        FastQueue list = new FastQueue(100, describe.getDescriptionType(), false);
        System.out.println("Detecting");
        detector.detect(input);
        System.out.println("Describing");
        describe.setImage(input);
        for (int i = 0; i < detector.getNumberOfFeatures(); ++i) {
            Object d;
            Point2D_F64 p = detector.getLocation(i);
            double radius = detector.getRadius(i);
            double ori = detector.getOrientation(i);
            if (!describe.process(p.x, p.y, ori, radius, d = describe.createDescription())) continue;
            list.add(d);
            location.add(p.copy());
        }
        return list;
    }

    public static void main(String[] args) {
        String file1 = UtilIO.pathExample("stitch/kayak_01.jpg");
        String file2 = UtilIO.pathExample("stitch/kayak_02.jpg");
        InterestPointDetector<GrayF32> detector = FactoryInterestPoint.fastHessian(new ConfigFastHessian(1.0f, 10, -1, 2, 9, 4, 4));
        DescribeRegionPoint<GrayF32, BrightFeature> describeA = FactoryDescribeRegionPoint.surfStable(null, GrayF32.class);
        ConvertTupleDesc<TupleDesc_F64, TupleDesc_S8> converter = FactoryConvertTupleDesc.real_F64_S8(((TupleDesc_F64)describeA.createDescription()).size());
        DescribeRegionPointConvert<GrayF32, TupleDesc_F64, TupleDesc_S8> describeB = new DescribeRegionPointConvert<GrayF32, TupleDesc_F64, TupleDesc_S8>(describeA, converter);
        ScoreAssociation<TupleDesc_F64> scoreA = FactoryAssociation.scoreSad(TupleDesc_F64.class);
        ScoreAssociation<TupleDesc_S8> scoreB = FactoryAssociation.scoreSad(TupleDesc_S8.class);
        BufferedImage image1 = UtilImageIO.loadImage(file1);
        BufferedImage image2 = UtilImageIO.loadImage(file2);
        CompareConvertedDescriptionsApp.visualize("Original", image1, image2, detector, describeA, scoreA);
        CompareConvertedDescriptionsApp.visualize("Modified", image1, image2, detector, describeB, scoreB);
        System.out.println("Done");
    }
}

