/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.associate;

import boofcv.abst.feature.associate.ScoreAssociateEuclideanSq_F32;
import boofcv.abst.feature.associate.ScoreAssociateEuclideanSq_F64;
import boofcv.abst.feature.associate.ScoreAssociateEuclidean_F64;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.associate.ScoreAssociateNccFeature;
import boofcv.abst.feature.associate.ScoreAssociateSad_F32;
import boofcv.abst.feature.associate.ScoreAssociateSad_F64;
import boofcv.abst.feature.associate.ScoreAssociateSad_U8;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_U8;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;

public class VisualizeScorePanel
extends StandardAlgConfigPanel
implements ActionListener {
    JComboBox scoreTypes = new JComboBox();
    Class type;
    ScoreAssociation selected;
    Listener listener;

    public VisualizeScorePanel(Listener listener) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.scoreTypes.addActionListener(this);
        this.scoreTypes.setMaximumSize(this.scoreTypes.getPreferredSize());
        this.listener = listener;
        this.addLabeled(this.scoreTypes, "Score: ", this);
    }

    public void setFeatureType(Class type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.scoreTypes.removeActionListener(this);
        this.scoreTypes.removeAllItems();
        if (type == TupleDesc_B.class) {
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateHamming_B(), "Hamming"));
        } else if (type == NccFeature.class) {
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateNccFeature(), "NCC"));
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateEuclidean_F64(), "Euclidean"));
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateEuclideanSq_F64(), "Euclidean2"));
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateSad_F64(), "SAD"));
        } else if (TupleDesc_F64.class.isAssignableFrom(type)) {
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateEuclidean_F64(), "Euclidean"));
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateEuclideanSq_F64(), "Euclidean2"));
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateSad_F64(), "SAD"));
        } else if (type == TupleDesc_F32.class) {
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateEuclideanSq_F32(), "Euclidean2"));
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateSad_F32(), "SAD"));
        } else if (type == TupleDesc_U8.class) {
            this.scoreTypes.addItem(new ScoreItem(new ScoreAssociateSad_U8(), "SAD"));
        } else {
            throw new RuntimeException("Unknown description type " + type.getSimpleName());
        }
        this.selected = ((ScoreItem)this.scoreTypes.getSelectedItem()).assoc;
        this.scoreTypes.revalidate();
        this.scoreTypes.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScoreItem item = (ScoreItem)this.scoreTypes.getSelectedItem();
        this.selected = item.assoc;
        if (this.listener != null) {
            this.listener.changedSetting();
        }
    }

    public ScoreAssociation getSelected() {
        return this.selected;
    }

    private static class ScoreItem {
        String name;
        ScoreAssociation assoc;

        private ScoreItem(ScoreAssociation assoc, String name) {
            this.assoc = assoc;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Listener {
        public void changedSetting();
    }
}

