/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.distort;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.core.image.border.BorderType;
import boofcv.gui.SelectInputPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.ProgressMonitorThread;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShowLensDistortion<T extends ImageGray>
extends SelectInputPanel
implements ChangeListener,
ItemListener {
    double radial1 = 0.0;
    double radial2 = 0.0;
    double tangential1 = 0.0;
    double tangential2 = 0.0;
    boolean fullView = false;
    Class<T> imageType;
    JSpinner radialOrder1;
    JSpinner radialOrder2;
    JSpinner tangentialOrder1;
    JSpinner tangentialOrder2;
    JCheckBox showFullImage;
    ImagePanel gui = new ImagePanel();
    boolean processedImage = false;
    Planar<T> input;
    Planar<T> output;
    BufferedImage renderedImage;
    BufferedImage outputImage;
    volatile int progress;

    public ShowLensDistortion(Class<T> imageType) {
        this.imageType = imageType;
        this.input = new Planar<T>(imageType, 1, 1, 3);
        this.output = new Planar<T>(imageType, 1, 1, 3);
        this.addToToolbar(this.createRadialSelect());
        this.setMainGUI(this.gui);
    }

    private JPanel createRadialSelect() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 0));
        this.radialOrder1 = new JSpinner(new SpinnerNumberModel(this.radial1, -1.0, 2.0, 0.05));
        this.radialOrder1.addChangeListener(this);
        int h = this.radialOrder1.getPreferredSize().height;
        this.radialOrder1.setPreferredSize(new Dimension(50, h));
        this.radialOrder1.setMaximumSize(this.radialOrder1.getPreferredSize());
        this.radialOrder2 = new JSpinner(new SpinnerNumberModel(this.radial2, -1.0, 2.0, 0.05));
        this.radialOrder2.addChangeListener(this);
        this.radialOrder2.setPreferredSize(new Dimension(50, h));
        this.radialOrder2.setMaximumSize(this.radialOrder1.getPreferredSize());
        this.tangentialOrder1 = new JSpinner(new SpinnerNumberModel(this.tangential1, -1.0, 1.0, 0.01));
        this.tangentialOrder1.addChangeListener(this);
        this.tangentialOrder1.setPreferredSize(new Dimension(50, h));
        this.tangentialOrder1.setMaximumSize(this.tangentialOrder1.getPreferredSize());
        this.tangentialOrder2 = new JSpinner(new SpinnerNumberModel(this.tangential2, -1.0, 1.0, 0.01));
        this.tangentialOrder2.addChangeListener(this);
        this.tangentialOrder2.setPreferredSize(new Dimension(50, h));
        this.tangentialOrder2.setMaximumSize(this.tangentialOrder2.getPreferredSize());
        this.showFullImage = new JCheckBox();
        this.showFullImage.setSelected(this.fullView);
        this.showFullImage.addItemListener(this);
        ret.add(Box.createRigidArea(new Dimension(10, 1)));
        ret.add(new JLabel("Radial 1:"));
        ret.add(this.radialOrder1);
        ret.add(Box.createRigidArea(new Dimension(10, 1)));
        ret.add(new JLabel("Radial 2:"));
        ret.add(this.radialOrder2);
        ret.add(Box.createRigidArea(new Dimension(10, 1)));
        ret.add(new JLabel("T1:"));
        ret.add(this.tangentialOrder1);
        ret.add(Box.createRigidArea(new Dimension(10, 1)));
        ret.add(new JLabel("T2:"));
        ret.add(this.tangentialOrder2);
        ret.add(Box.createRigidArea(new Dimension(10, 1)));
        ret.add(new JLabel("Full:"));
        ret.add(this.showFullImage);
        ret.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("enabled")) {
                    JPanel src = (JPanel)evt.getSource();
                    boolean value = (Boolean)evt.getNewValue();
                    for (int i = 0; i < src.getComponentCount(); ++i) {
                        src.getComponent(i).setEnabled(value);
                    }
                }
            }
        });
        return ret;
    }

    public void process(final BufferedImage image) {
        this.input.reshape(image.getWidth(), image.getHeight());
        this.output.reshape(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFromMulti(image, this.input, true, this.imageType);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowLensDistortion.this.setInputImage(image);
                ShowLensDistortion.this.outputImage = new BufferedImage(ShowLensDistortion.this.input.width, ShowLensDistortion.this.input.height, 4);
                ShowLensDistortion.this.renderedImage = new BufferedImage(ShowLensDistortion.this.input.width, ShowLensDistortion.this.input.height, 4);
                ShowLensDistortion.this.gui.setBufferedImage(ShowLensDistortion.this.outputImage);
                ShowLensDistortion.this.gui.setPreferredSize(new Dimension(ShowLensDistortion.this.input.width, ShowLensDistortion.this.input.height));
                ShowLensDistortion.this.gui.repaint();
                ShowLensDistortion.this.processedImage = true;
                ShowLensDistortion.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.performUpdate();
    }

    private synchronized void performUpdate() {
        if (this.input == null || this.output == null) {
            return;
        }
        this.progress = 0;
        MyMonitorThread thread = new MyMonitorThread(this);
        thread.start();
        IntrinsicParameters param = new IntrinsicParameters().fsetK((double)this.input.width * 0.8, (double)this.input.width * 0.8, 0.0, this.input.width / 2, this.input.height / 2, this.input.width, this.input.height).fsetRadial(this.radial1, this.radial2).fsetTangental(this.tangential1, this.tangential2);
        AdjustmentType type = this.fullView ? AdjustmentType.FULL_VIEW : AdjustmentType.NONE;
        ImageDistort distort = LensDistortionOps.imageRemoveDistortion(type, BorderType.ZERO, param, null, this.input.getImageType());
        distort.apply(this.input, this.output);
        thread.stopThread();
        ConvertBufferedImage.convertTo(this.output, this.renderedImage, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowLensDistortion.this.outputImage.createGraphics().drawImage((Image)ShowLensDistortion.this.renderedImage, 0, 0, null);
                ShowLensDistortion.this.gui.repaint();
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        } else {
            System.err.println("Can't open " + ((PathLabel)this.inputRefs.get(index)).getPath());
            System.exit(1);
        }
    }

    @Override
    public synchronized void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.radialOrder1) {
            this.radial1 = ((Number)this.radialOrder1.getValue()).doubleValue();
        } else if (e.getSource() == this.radialOrder2) {
            this.radial2 = ((Number)this.radialOrder2.getValue()).doubleValue();
        } else if (e.getSource() == this.tangentialOrder1) {
            this.tangential1 = ((Number)this.tangentialOrder1.getValue()).doubleValue();
        } else if (e.getSource() == this.tangentialOrder2) {
            this.tangential2 = ((Number)this.tangentialOrder2.getValue()).doubleValue();
        }
        this.performUpdate();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fullView = this.showFullImage.isSelected();
        this.performUpdate();
    }

    public static void main(String[] args) {
        ShowLensDistortion<GrayU8> app = new ShowLensDistortion<GrayU8>(GrayU8.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Lens Distortion", true);
    }

    private class MyMonitorThread
    extends ProgressMonitorThread {
        protected MyMonitorThread(Component comp) {
            super(new ProgressMonitor(comp, "Applying Distortion", "", 0, ShowLensDistortion.this.input.getNumBands()));
        }

        @Override
        public void doRun() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyMonitorThread.this.monitor.setProgress(ShowLensDistortion.this.progress);
                }
            });
        }
    }
}

