/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.distort;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.BorderType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class RemoveLensDistortionApp
extends SelectAlgorithmAndInputPanel {
    ListDisplayPanel gui = new ListDisplayPanel();
    IntrinsicParameters param;
    Planar<GrayF32> dist;
    Planar<GrayF32> undist;
    boolean hasProcessed = false;

    public RemoveLensDistortionApp() {
        super(0);
        this.setMainGUI(this.gui);
    }

    public void configure(final BufferedImage orig, IntrinsicParameters param) {
        this.param = param;
        this.dist = ConvertBufferedImage.convertFromMulti(orig, null, true, GrayF32.class);
        this.undist = new Planar<GrayF32>(GrayF32.class, this.dist.getWidth(), this.dist.getHeight(), this.dist.getNumBands());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RemoveLensDistortionApp.this.gui.reset();
                RemoveLensDistortionApp.this.gui.addItem(new ImagePanel(orig), "Original");
            }
        });
        PointTransform_F32 add_p_to_p = LensDistortionOps.transformPoint(param).distort_F32(true, true);
        this.addUndistorted("No Adjustment", add_p_to_p);
        PointTransform_F32 shrink = LensDistortionOps.transform_F32(AdjustmentType.EXPAND, param, null, true);
        this.addUndistorted("Shrink", shrink);
        PointTransform_F32 fullView = LensDistortionOps.transform_F32(AdjustmentType.FULL_VIEW, param, null, true);
        this.addUndistorted("Full View", fullView);
        this.hasProcessed = true;
    }

    private void addUndistorted(final String name, PointTransform_F32 model) {
        InterpolatePixelS<GrayF32> interp = FactoryInterpolation.bilinearPixelS(GrayF32.class, BorderType.ZERO);
        ImageDistort<GrayF32, GrayF32> undistorter = FactoryDistort.distortSB(false, interp, GrayF32.class);
        undistorter.setModel(new PointToPixelTransform_F32(model));
        DistortImageOps.distortPL(this.dist, this.undist, undistorter);
        final BufferedImage out = ConvertBufferedImage.convertTo(this.undist, null, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RemoveLensDistortionApp.this.gui.addItem(new ImagePanel(out), name);
            }
        });
    }

    @Override
    public void refreshAll(Object[] cookies) {
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
    }

    @Override
    public void changeInput(String name, int index) {
        PathLabel refs = (PathLabel)this.inputRefs.get(index);
        IntrinsicParameters param = (IntrinsicParameters)UtilIO.loadXML(this.media.openFile(refs.getPath(0)));
        BufferedImage orig = this.media.openImage(refs.getPath(1));
        this.configure(orig, param);
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.hasProcessed;
    }

    public static void main(String[] args) {
        RemoveLensDistortionApp app = new RemoveLensDistortionApp();
        String calibDir = UtilIO.pathExample("calibration/mono/Sony_DSC-HX5V_Chess/");
        String imageDir = UtilIO.pathExample("structure/");
        String bumbleDir = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess/");
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Sony HX5V", calibDir + "intrinsic.xml", imageDir + "dist_cyto_01.jpg"));
        inputs.add(new PathLabel("BumbleBee2", bumbleDir + "intrinsicLeft.xml", bumbleDir + "left01.jpg"));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Remove Lens Distortion", true);
        System.out.println("Done");
    }
}

