/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.border.BorderType;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.stereo.RectifiedPairPanel;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.se.Se3_F64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.ejml.data.DenseMatrix64F;

public class ShowRectifyCalibratedApp
extends SelectAlgorithmAndInputPanel {
    ListDisplayPanel gui = new ListDisplayPanel();
    StereoParameters param;
    Planar<GrayF32> distLeft;
    Planar<GrayF32> distRight;
    Planar<GrayF32> rectLeft;
    Planar<GrayF32> rectRight;
    boolean hasProcessed = false;

    public ShowRectifyCalibratedApp() {
        super(0);
        this.setMainGUI(this.gui);
    }

    public void configure(final BufferedImage origLeft, final BufferedImage origRight, StereoParameters param) {
        this.param = param;
        this.distLeft = ConvertBufferedImage.convertFromMulti(origLeft, null, true, GrayF32.class);
        this.distRight = ConvertBufferedImage.convertFromMulti(origRight, null, true, GrayF32.class);
        this.rectLeft = new Planar<GrayF32>(GrayF32.class, this.distLeft.getWidth(), this.distLeft.getHeight(), this.distLeft.getNumBands());
        this.rectRight = new Planar<GrayF32>(GrayF32.class, this.distRight.getWidth(), this.distRight.getHeight(), this.distRight.getNumBands());
        RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
        Se3_F64 leftToRight = param.getRightToLeft().invert(null);
        DenseMatrix64F K1 = PerspectiveOps.calibrationMatrix(param.getLeft(), null);
        DenseMatrix64F K2 = PerspectiveOps.calibrationMatrix(param.getRight(), null);
        rectifyAlg.process(K1, new Se3_F64(), K2, leftToRight);
        DenseMatrix64F rect1 = rectifyAlg.getRect1();
        DenseMatrix64F rect2 = rectifyAlg.getRect2();
        DenseMatrix64F rectK = rectifyAlg.getCalibrationMatrix();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowRectifyCalibratedApp.this.gui.reset();
                ShowRectifyCalibratedApp.this.gui.addItem(new RectifiedPairPanel(true, origLeft, origRight), "Original");
            }
        });
        this.addRectified("No Adjustment", rect1, rect2);
        RectifyImageOps.allInsideLeft(param.left, rect1, rect2, rectK);
        this.addRectified("All Inside", rect1, rect2);
        RectifyImageOps.fullViewLeft(param.left, rect1, rect2, rectK);
        this.addRectified("Full View", rect1, rect2);
        this.hasProcessed = true;
    }

    private void addRectified(final String name, DenseMatrix64F rect1, DenseMatrix64F rect2) {
        ImageType<GrayF32> imageType = ImageType.single(GrayF32.class);
        ImageDistort<GrayF32, GrayF32> imageDistortLeft = RectifyImageOps.rectifyImage(this.param.getLeft(), rect1, BorderType.ZERO, imageType);
        ImageDistort<GrayF32, GrayF32> imageDistortRight = RectifyImageOps.rectifyImage(this.param.getRight(), rect2, BorderType.ZERO, imageType);
        GImageMiscOps.fill(this.rectLeft, 0.0);
        GImageMiscOps.fill(this.rectRight, 0.0);
        DistortImageOps.distortPL(this.distLeft, this.rectLeft, imageDistortLeft);
        DistortImageOps.distortPL(this.distRight, this.rectRight, imageDistortRight);
        final BufferedImage outLeft = ConvertBufferedImage.convertTo(this.rectLeft, null, true);
        final BufferedImage outRight = ConvertBufferedImage.convertTo(this.rectRight, null, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowRectifyCalibratedApp.this.gui.addItem(new RectifiedPairPanel(true, outLeft, outRight), name);
            }
        });
    }

    @Override
    public void refreshAll(Object[] cookies) {
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
    }

    @Override
    public void changeInput(String name, int index) {
        PathLabel refs = (PathLabel)this.inputRefs.get(index);
        StereoParameters param = (StereoParameters)UtilIO.loadXML(this.media.openFile(refs.getPath(0)));
        BufferedImage origLeft = this.media.openImage(refs.getPath(1));
        BufferedImage origRight = this.media.openImage(refs.getPath(2));
        this.configure(origLeft, origRight, param);
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.hasProcessed;
    }

    public static void main(String[] args) {
        ShowRectifyCalibratedApp app = new ShowRectifyCalibratedApp();
        String dir = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess/");
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("BumbleBee", dir + "stereo.xml", dir + "left05.jpg", dir + "right05.jpg"));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Calibrated Camera Rectification", true);
        System.out.println("Done");
    }
}

