/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.demonstrations.calibration.BaseCalibrationConfig;
import boofcv.io.MediaManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ParseStereoCalibrationConfig
extends BaseCalibrationConfig {
    public List<String> leftImages = new ArrayList<String>();
    public List<String> rightImages = new ArrayList<String>();

    public ParseStereoCalibrationConfig(MediaManager media) {
        this.media = media;
    }

    public ParseStereoCalibrationConfig() {
    }

    public boolean parse(String fileName) {
        Reader input = this.media.openFile(fileName);
        if (input == null) {
            return false;
        }
        BufferedReader reader = new BufferedReader(input);
        String infoFile = null;
        this.leftImages.clear();
        this.rightImages.clear();
        try {
            String line = reader.readLine();
            while (line != null && line.charAt(0) == '#') {
                line = reader.readLine();
            }
            if (line == null) {
                return false;
            }
            String[] v = line.split("\\s");
            if (v.length != 3) {
                return false;
            }
            infoFile = v[2];
            while ((line = reader.readLine()) != null) {
                v = line.split("\\s");
                if (v.length != 3) continue;
                if (v[0].compareTo("addLeft") == 0) {
                    this.leftImages.add(v[2]);
                    continue;
                }
                if (v[0].compareTo("addRight") != 0) continue;
                this.rightImages.add(v[2]);
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        if (infoFile == null || this.rightImages.size() == 0 || this.leftImages.size() != this.rightImages.size()) {
            return false;
        }
        try {
            this.parseTarget(infoFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public List<String> getLeftImages() {
        return this.leftImages;
    }

    public List<String> getRightImages() {
        return this.rightImages;
    }
}

