/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.alg.fiducial.calib.grid.DetectSquareGridFiducial;
import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.filter.binary.Contour;
import boofcv.demonstrations.calibration.CommonDetectCalibrationApp;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectCalibrationSquareGridApp
extends CommonDetectCalibrationApp {
    DetectSquareGridFiducial<GrayF32> alg;
    ConfigSquareGrid config;

    public DetectCalibrationSquareGridApp(int numRows, int numColumns, double squareWidth, double spaceWidth, boolean forCalibration, List<String> exampleInputs) {
        super(numRows, numColumns, exampleInputs);
        this.config = new ConfigSquareGrid(numRows, numColumns, squareWidth, spaceWidth);
        this.declareDetector();
    }

    @Override
    public void declareDetector() {
        if (this.controlPanel.isManual()) {
            this.config.thresholding.type = ThresholdType.FIXED;
            this.config.thresholding.fixedThreshold = this.controlPanel.getThresholdLevel();
        } else {
            this.config.thresholding.type = ThresholdType.LOCAL_SQUARE;
        }
        this.config.numRows = this.controlPanel.getGridRows();
        this.config.numCols = this.controlPanel.getGridColumns();
        this.alg = FactoryCalibrationTarget.detectorSquareGrid(this.config).getAlgorithm();
    }

    @Override
    protected boolean process(GrayF32 image) {
        return this.alg.process(image);
    }

    @Override
    protected GrayU8 getBinaryImage() {
        return this.alg.getBinary();
    }

    @Override
    protected List<List<SquareNode>> getClusters() {
        return this.alg.getClusters();
    }

    @Override
    protected List<Point2D_F64> getCalibrationPoints() {
        return this.alg.getCalibrationPoints();
    }

    @Override
    protected List<Contour> getContours() {
        return this.alg.getDetectorSquare().getAllContours();
    }

    @Override
    protected FastQueue<Polygon2D_F64> getFoundPolygons() {
        return this.alg.getDetectorSquare().getFoundPolygons();
    }

    @Override
    protected List<SquareGrid> getGrids() {
        return this.alg.getGrids().getGrids();
    }

    public static void main(String[] args) {
        ArrayList<String> examples = new ArrayList<String>();
        for (int i = 1; i <= 11; ++i) {
            examples.add(UtilIO.pathExample(String.format("calibration/stereo/Bumblebee2_Square/left%02d.jpg", i)));
        }
        DetectCalibrationSquareGridApp app = new DetectCalibrationSquareGridApp(4, 3, 1.0, 1.0, false, examples);
        app.openFile(new File((String)examples.get(0)));
        app.waitUntilDoneProcessing();
        ShowImages.showWindow(app, "Square Grid Detector", true);
    }
}

