/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.demonstrations.binary.ContourControlPanel;
import boofcv.demonstrations.shapes.ThresholdControlPanel;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.gui.DemonstrationBase;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ImageZoomPanel;
import boofcv.gui.image.ShowImages;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class VisualizeBinaryContourApp<T extends ImageGray>
extends DemonstrationBase<T>
implements ThresholdControlPanel.Listener {
    VisualizePanel guiImage;
    ContourControlPanel controls = new ContourControlPanel(this);
    LinearContourLabelChang2004 contourAlg;
    InputToBinary<T> inputToBinary;
    GrayU8 binary = new GrayU8(1, 1);
    GrayS32 labeled = new GrayS32(1, 1);
    BufferedImage original;
    BufferedImage work;

    public VisualizeBinaryContourApp(List<String> exampleInputs, ImageType<T> imageType) {
        super(exampleInputs, imageType);
        this.guiImage = new VisualizePanel();
        this.add("West", this.controls);
        this.add("Center", this.guiImage);
        ConfigThreshold config = this.controls.getThreshold().createConfig();
        this.inputToBinary = FactoryThresholdBinary.threshold(config, imageType.getImageClass());
        this.contourAlg = new LinearContourLabelChang2004(this.controls.getConnectRule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processImage(final BufferedImage buffered, T input) {
        if (buffered != null) {
            this.original = VisualizeBinaryContourApp.conditionalDeclare(buffered, this.original);
            this.work = VisualizeBinaryContourApp.conditionalDeclare(buffered, this.work);
            this.original.createGraphics().drawImage((Image)buffered, 0, 0, null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dimension d = VisualizeBinaryContourApp.this.guiImage.getPreferredSize();
                    if (d.getWidth() < (double)buffered.getWidth() || d.getHeight() < (double)buffered.getHeight()) {
                        VisualizeBinaryContourApp.this.guiImage.setPreferredSize(new Dimension(buffered.getWidth(), buffered.getHeight()));
                    }
                }
            });
        }
        this.binary.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.labeled.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.inputToBinary.process(input, this.binary);
        VisualizeBinaryContourApp visualizeBinaryContourApp = this;
        synchronized (visualizeBinaryContourApp) {
            this.contourAlg.process(this.binary, this.labeled);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeBinaryContourApp.this.viewUpdated();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageThresholdUpdated() {
        VisualizeBinaryContourApp visualizeBinaryContourApp = this;
        synchronized (visualizeBinaryContourApp) {
            ConfigThreshold config = this.controls.getThreshold().createConfig();
            this.inputToBinary = FactoryThresholdBinary.threshold(config, this.imageType.getImageClass());
            this.reprocessSingleImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contourAlgUpdated() {
        VisualizeBinaryContourApp visualizeBinaryContourApp = this;
        synchronized (visualizeBinaryContourApp) {
            this.contourAlg = new LinearContourLabelChang2004(this.controls.getConnectRule());
            this.reprocessSingleImage();
        }
    }

    public void viewUpdated() {
        BufferedImage active = null;
        if (this.controls.selectedView == 0) {
            active = this.original;
        } else if (this.controls.selectedView == 1) {
            VisualizeBinaryData.renderBinary(this.binary, false, this.work);
            active = this.work;
            this.work.setRGB(0, 0, this.work.getRGB(0, 0));
        } else {
            Graphics2D g2 = this.work.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, this.work.getWidth(), this.work.getHeight());
            active = this.work;
        }
        this.guiImage.setScale(this.controls.zoom);
        this.guiImage.setBufferedImage(active);
        this.guiImage.repaint();
    }

    public static void main(String[] args) {
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("shapes/shapes02.png");
        examples.add("shapes/concave01.jpg");
        examples.add("shapes/polygons01.jpg");
        VisualizeBinaryContourApp<GrayF32> app = new VisualizeBinaryContourApp<GrayF32>(examples, ImageType.single(GrayF32.class));
        app.openFile(new File((String)examples.get(0)));
        app.waitUntilDoneProcessing();
        ShowImages.showWindow(app, "Contour Visualization", true);
    }

    class VisualizePanel
    extends ImageZoomPanel {
        VisualizePanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
            VisualizeBinaryContourApp visualizeBinaryContourApp = VisualizeBinaryContourApp.this;
            synchronized (visualizeBinaryContourApp) {
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                List contours = VisualizeBinaryContourApp.this.contourAlg.getContours().toList();
                g2.setStroke(new BasicStroke(1.0f));
                g2.setColor(Color.RED);
                VisualizeBinaryData.renderExternal(contours, true, true, this.scale, g2);
            }
        }
    }
}

