/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.binary;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.demonstrations.binary.SelectHistogramThresholdPanel;
import boofcv.factory.filter.binary.FactoryBinaryImageOps;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DemoBinaryImageOpsApp<T extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements SelectHistogramThresholdPanel.Listener {
    Class<T> imageType;
    T imageInput;
    GrayU8 imageBinary;
    GrayU8 imageOutput;
    GrayU8 selectedVisualize;
    FilterImageInterface<GrayU8, GrayU8> filter;
    BufferedImage work;
    boolean processedImage = false;
    JComboBox imagesCombo;
    SelectHistogramThresholdPanel selectThresh;
    ImagePanel gui = new ImagePanel();

    public DemoBinaryImageOpsApp(Class<T> imageType) {
        super(1);
        this.imageType = imageType;
        this.addAlgorithm(0, "Erode-4", FactoryBinaryImageOps.erode4());
        this.addAlgorithm(0, "Erode-8", FactoryBinaryImageOps.erode8());
        this.addAlgorithm(0, "Dilate-4", FactoryBinaryImageOps.dilate4());
        this.addAlgorithm(0, "Dilate-8", FactoryBinaryImageOps.dilate8());
        this.addAlgorithm(0, "Edge-4", FactoryBinaryImageOps.edge4());
        this.addAlgorithm(0, "Edge-8", FactoryBinaryImageOps.edge8());
        this.addAlgorithm(0, "Remove Noise", FactoryBinaryImageOps.removePointNoise());
        JPanel body = new JPanel();
        body.setLayout(new BorderLayout());
        body.add((Component)this.createLeftPanel(), "North");
        body.add((Component)this.gui, "Center");
        this.imageInput = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.imageBinary = new GrayU8(1, 1);
        this.selectedVisualize = this.imageOutput = new GrayU8(1, 1);
        this.setMainGUI(body);
    }

    private JPanel createLeftPanel() {
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 0));
        this.imagesCombo = new JComboBox();
        this.imagesCombo.addItem("Thresholded");
        this.imagesCombo.addItem("Filtered");
        this.imagesCombo.addActionListener(this);
        this.imagesCombo.setSelectedIndex(1);
        this.imagesCombo.setMaximumSize(this.imagesCombo.getPreferredSize());
        this.selectThresh = new SelectHistogramThresholdPanel(20, true);
        this.selectThresh.setListener(this);
        left.add(this.imagesCombo);
        left.add(this.selectThresh);
        left.add(Box.createHorizontalGlue());
        return left;
    }

    public void process(final BufferedImage image) {
        ((ImageGray)this.imageInput).reshape(image.getWidth(), image.getHeight());
        this.imageBinary.reshape(image.getWidth(), image.getHeight());
        this.imageOutput.reshape(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFromSingle(image, this.imageInput, this.imageType);
        final double threshold = GThresholdImageOps.computeOtsu(this.imageInput, 0, 255);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DemoBinaryImageOpsApp.this.selectThresh.setThreshold((int)threshold);
                DemoBinaryImageOpsApp.this.setInputImage(image);
                DemoBinaryImageOpsApp.this.selectThresh.getHistogramPanel().update((ImageGray)DemoBinaryImageOpsApp.this.imageInput);
                DemoBinaryImageOpsApp.this.selectThresh.repaint();
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.filter = (FilterImageInterface)cookie;
        this.performWork();
    }

    private synchronized void performWork() {
        if (this.filter == null) {
            return;
        }
        GThresholdImageOps.threshold(this.imageInput, this.imageBinary, this.selectThresh.getThreshold(), this.selectThresh.isDown());
        this.filter.process(this.imageBinary, this.imageOutput);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DemoBinaryImageOpsApp.this.work == null || DemoBinaryImageOpsApp.this.work.getWidth() != ((ImageGray)DemoBinaryImageOpsApp.this.imageInput).width || DemoBinaryImageOpsApp.this.work.getHeight() != ((ImageGray)DemoBinaryImageOpsApp.this.imageInput).height) {
                    DemoBinaryImageOpsApp.this.work = new BufferedImage(((ImageGray)DemoBinaryImageOpsApp.this.imageInput).width, ((ImageGray)DemoBinaryImageOpsApp.this.imageInput).height, 4);
                }
                VisualizeBinaryData.renderBinary(DemoBinaryImageOpsApp.this.selectedVisualize, false, DemoBinaryImageOpsApp.this.work);
                DemoBinaryImageOpsApp.this.gui.setBufferedImage(DemoBinaryImageOpsApp.this.work);
                DemoBinaryImageOpsApp.this.gui.setPreferredSize(new Dimension(((ImageGray)DemoBinaryImageOpsApp.this.imageInput).width, ((ImageGray)DemoBinaryImageOpsApp.this.imageInput).height));
                DemoBinaryImageOpsApp.this.processedImage = true;
                DemoBinaryImageOpsApp.this.gui.repaint();
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.imagesCombo) {
            int index = this.imagesCombo.getSelectedIndex();
            this.selectedVisualize = index == 0 ? this.imageBinary : this.imageOutput;
            if (this.work != null) {
                VisualizeBinaryData.renderBinary(this.selectedVisualize, false, this.work);
                this.gui.repaint();
            }
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void histogramThresholdChange() {
        this.performWork();
    }

    public static void main(String[] args) {
        DemoBinaryImageOpsApp<GrayF32> app = new DemoBinaryImageOpsApp<GrayF32>(GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("particles", UtilIO.pathExample("particles01.jpg")));
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Binary Image Ops", true);
        System.out.println("Done");
    }
}

