/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.fft;

import boofcv.abst.transform.fft.DiscreteFourierTransform;
import boofcv.abst.transform.fft.GeneralFft_to_DiscreteFourierTransform_F32;
import boofcv.abst.transform.fft.GeneralFft_to_DiscreteFourierTransform_F64;
import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;

public class DiscreteFourierTransformOps {
    public static DiscreteFourierTransform<GrayF32, InterleavedF32> createTransformF32() {
        return new GeneralFft_to_DiscreteFourierTransform_F32();
    }

    public static DiscreteFourierTransform<GrayF64, InterleavedF64> createTransformF64() {
        return new GeneralFft_to_DiscreteFourierTransform_F64();
    }

    public static boolean isPowerOf2(int x) {
        if (x <= 1) {
            return false;
        }
        return (x & x - 1) == 0;
    }

    public static int nextPow2(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((x & x - 1) == 0) {
            if (x == 1) {
                return 2;
            }
            return x;
        }
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        x |= x >>> 32;
        return x + 1;
    }

    public static void checkImageArguments(ImageBase image, ImageInterleaved transform) {
        InputSanityCheck.checkSameShape(image, transform);
        if (2 != transform.getNumBands()) {
            throw new IllegalArgumentException("The transform must have two bands");
        }
    }

    public static void shiftZeroFrequency(InterleavedF32 transform, boolean forward) {
        int hw = transform.width / 2;
        int hh = transform.height / 2;
        if (transform.width % 2 == 0 && transform.height % 2 == 0) {
            for (int y = 0; y < hh; ++y) {
                for (int x = 0; x < hw; ++x) {
                    float ra = transform.getBand(x, y, 0);
                    float ia = transform.getBand(x, y, 1);
                    float rb = transform.getBand(x + hw, y + hh, 0);
                    float ib = transform.getBand(x + hw, y + hh, 1);
                    transform.setBand(x, y, 0, rb);
                    transform.setBand(x, y, 1, ib);
                    transform.setBand(x + hw, y + hh, 0, ra);
                    transform.setBand(x + hw, y + hh, 1, ia);
                    ra = transform.getBand(x + hw, y, 0);
                    ia = transform.getBand(x + hw, y, 1);
                    rb = transform.getBand(x, y + hh, 0);
                    ib = transform.getBand(x, y + hh, 1);
                    transform.setBand(x + hw, y, 0, rb);
                    transform.setBand(x + hw, y, 1, ib);
                    transform.setBand(x, y + hh, 0, ra);
                    transform.setBand(x, y + hh, 1, ia);
                }
            }
        } else {
            int w = transform.width;
            int h = transform.height;
            int hw1 = hw + w % 2;
            int hh1 = hh + h % 2;
            if (forward) {
                InterleavedF32 storageTL = new InterleavedF32(hw1, hh1, 2);
                storageTL.setTo(transform.subimage(0, 0, hw1, hh1, null));
                InterleavedF32 storageTR = new InterleavedF32(hw, hh1, 2);
                storageTR.setTo(transform.subimage(hw1, 0, w, hh1, null));
                ((InterleavedF32)transform.subimage(0, 0, hw, hh, null)).setTo(transform.subimage(hw1, hh1, w, h, null));
                ((InterleavedF32)transform.subimage(hw, 0, w, hh, null)).setTo(transform.subimage(0, hh1, hw1, h, null));
                ((InterleavedF32)transform.subimage(hw, hh, w, h, null)).setTo(storageTL);
                ((InterleavedF32)transform.subimage(0, hh, hw, h, null)).setTo(storageTR);
            } else {
                InterleavedF32 storageBL = new InterleavedF32(hw, hh1, 2);
                storageBL.setTo(transform.subimage(0, hh, hw, h, null));
                InterleavedF32 storageBR = new InterleavedF32(hw1, hh1, 2);
                storageBR.setTo(transform.subimage(hw, hh, w, h, null));
                ((InterleavedF32)transform.subimage(hw1, hh1, w, h, null)).setTo(transform.subimage(0, 0, hw, hh, null));
                ((InterleavedF32)transform.subimage(0, hh1, hw1, h, null)).setTo(transform.subimage(hw, 0, w, hh, null));
                ((InterleavedF32)transform.subimage(hw1, 0, w, hh1, null)).setTo(storageBL);
                ((InterleavedF32)transform.subimage(0, 0, hw1, hh1, null)).setTo(storageBR);
            }
        }
    }

    public static void shiftZeroFrequency(InterleavedF64 transform, boolean forward) {
        int hw = transform.width / 2;
        int hh = transform.height / 2;
        if (transform.width % 2 == 0 && transform.height % 2 == 0) {
            for (int y = 0; y < hh; ++y) {
                for (int x = 0; x < hw; ++x) {
                    double ra = transform.getBand(x, y, 0);
                    double ia = transform.getBand(x, y, 1);
                    double rb = transform.getBand(x + hw, y + hh, 0);
                    double ib = transform.getBand(x + hw, y + hh, 1);
                    transform.setBand(x, y, 0, rb);
                    transform.setBand(x, y, 1, ib);
                    transform.setBand(x + hw, y + hh, 0, ra);
                    transform.setBand(x + hw, y + hh, 1, ia);
                    ra = transform.getBand(x + hw, y, 0);
                    ia = transform.getBand(x + hw, y, 1);
                    rb = transform.getBand(x, y + hh, 0);
                    ib = transform.getBand(x, y + hh, 1);
                    transform.setBand(x + hw, y, 0, rb);
                    transform.setBand(x + hw, y, 1, ib);
                    transform.setBand(x, y + hh, 0, ra);
                    transform.setBand(x, y + hh, 1, ia);
                }
            }
        } else {
            int w = transform.width;
            int h = transform.height;
            int hw1 = hw + w % 2;
            int hh1 = hh + h % 2;
            if (forward) {
                InterleavedF64 storageTL = new InterleavedF64(hw1, hh1, 2);
                storageTL.setTo(transform.subimage(0, 0, hw1, hh1, null));
                InterleavedF64 storageTR = new InterleavedF64(hw, hh1, 2);
                storageTR.setTo(transform.subimage(hw1, 0, w, hh1, null));
                ((InterleavedF64)transform.subimage(0, 0, hw, hh, null)).setTo(transform.subimage(hw1, hh1, w, h, null));
                ((InterleavedF64)transform.subimage(hw, 0, w, hh, null)).setTo(transform.subimage(0, hh1, hw1, h, null));
                ((InterleavedF64)transform.subimage(hw, hh, w, h, null)).setTo(storageTL);
                ((InterleavedF64)transform.subimage(0, hh, hw, h, null)).setTo(storageTR);
            } else {
                InterleavedF64 storageBL = new InterleavedF64(hw, hh1, 2);
                storageBL.setTo(transform.subimage(0, hh, hw, h, null));
                InterleavedF64 storageBR = new InterleavedF64(hw1, hh1, 2);
                storageBR.setTo(transform.subimage(hw, hh, w, h, null));
                ((InterleavedF64)transform.subimage(hw1, hh1, w, h, null)).setTo(transform.subimage(0, 0, hw, hh, null));
                ((InterleavedF64)transform.subimage(0, hh1, hw1, h, null)).setTo(transform.subimage(hw, 0, w, hh, null));
                ((InterleavedF64)transform.subimage(hw1, 0, w, hh1, null)).setTo(storageBL);
                ((InterleavedF64)transform.subimage(0, 0, hw1, hh1, null)).setTo(storageBR);
            }
        }
    }

    public static void magnitude(InterleavedF32 transform, GrayF32 magnitude) {
        DiscreteFourierTransformOps.checkImageArguments(magnitude, transform);
        for (int y = 0; y < transform.height; ++y) {
            int indexTran = transform.startIndex + y * transform.stride;
            int indexMag = magnitude.startIndex + y * magnitude.stride;
            int x = 0;
            while (x < transform.width) {
                float real = transform.data[indexTran];
                float img = transform.data[indexTran + 1];
                magnitude.data[indexMag++] = (float)Math.sqrt(real * real + img * img);
                ++x;
                indexTran += 2;
            }
        }
    }

    public static void magnitude(InterleavedF64 transform, GrayF64 magnitude) {
        DiscreteFourierTransformOps.checkImageArguments(magnitude, transform);
        for (int y = 0; y < transform.height; ++y) {
            int indexTran = transform.startIndex + y * transform.stride;
            int indexMag = magnitude.startIndex + y * magnitude.stride;
            int x = 0;
            while (x < transform.width) {
                double real = transform.data[indexTran];
                double img = transform.data[indexTran + 1];
                magnitude.data[indexMag++] = Math.sqrt(real * real + img * img);
                ++x;
                indexTran += 2;
            }
        }
    }

    public static void phase(InterleavedF32 transform, GrayF32 phase) {
        DiscreteFourierTransformOps.checkImageArguments(phase, transform);
        for (int y = 0; y < transform.height; ++y) {
            int indexTran = transform.startIndex + y * transform.stride;
            int indexPhase = phase.startIndex + y * phase.stride;
            int x = 0;
            while (x < transform.width) {
                float real = transform.data[indexTran];
                float img = transform.data[indexTran + 1];
                phase.data[indexPhase++] = (float)Math.atan2(img, real);
                ++x;
                indexTran += 2;
            }
        }
    }

    public static void phase(InterleavedF64 transform, GrayF64 phase) {
        DiscreteFourierTransformOps.checkImageArguments(phase, transform);
        for (int y = 0; y < transform.height; ++y) {
            int indexTran = transform.startIndex + y * transform.stride;
            int indexPhase = phase.startIndex + y * phase.stride;
            int x = 0;
            while (x < transform.width) {
                double real = transform.data[indexTran];
                double img = transform.data[indexTran + 1];
                phase.data[indexPhase++] = Math.atan2(img, real);
                ++x;
                indexTran += 2;
            }
        }
    }

    public static void realToComplex(GrayF32 real, InterleavedF32 complex) {
        DiscreteFourierTransformOps.checkImageArguments(real, complex);
        for (int y = 0; y < complex.height; ++y) {
            int indexReal = real.startIndex + y * real.stride;
            int indexComplex = complex.startIndex + y * complex.stride;
            int x = 0;
            while (x < real.width) {
                complex.data[indexComplex] = real.data[indexReal];
                complex.data[indexComplex + 1] = 0.0f;
                ++x;
                ++indexReal;
                indexComplex += 2;
            }
        }
    }

    public static void realToComplex(GrayF64 real, InterleavedF64 complex) {
        DiscreteFourierTransformOps.checkImageArguments(real, complex);
        for (int y = 0; y < complex.height; ++y) {
            int indexReal = real.startIndex + y * real.stride;
            int indexComplex = complex.startIndex + y * complex.stride;
            int x = 0;
            while (x < real.width) {
                complex.data[indexComplex] = real.data[indexReal];
                complex.data[indexComplex + 1] = 0.0;
                ++x;
                ++indexReal;
                indexComplex += 2;
            }
        }
    }

    public static void multiplyRealComplex(GrayF32 realA, InterleavedF32 complexB, InterleavedF32 complexC) {
        DiscreteFourierTransformOps.checkImageArguments(realA, complexB);
        InputSanityCheck.checkSameShape(complexB, complexC);
        for (int y = 0; y < realA.height; ++y) {
            int indexA = realA.startIndex + y * realA.stride;
            int indexB = complexB.startIndex + y * complexB.stride;
            int indexC = complexC.startIndex + y * complexC.stride;
            int x = 0;
            while (x < realA.width) {
                float real = realA.data[indexA];
                float realB = complexB.data[indexB];
                float imgB = complexB.data[indexB + 1];
                complexC.data[indexC] = real * realB;
                complexC.data[indexC + 1] = real * imgB;
                ++x;
                ++indexA;
                indexB += 2;
                indexC += 2;
            }
        }
    }

    public static void multiplyRealComplex(GrayF64 realA, InterleavedF64 complexB, InterleavedF64 complexC) {
        DiscreteFourierTransformOps.checkImageArguments(realA, complexB);
        InputSanityCheck.checkSameShape(complexB, complexC);
        for (int y = 0; y < realA.height; ++y) {
            int indexA = realA.startIndex + y * realA.stride;
            int indexB = complexB.startIndex + y * complexB.stride;
            int indexC = complexC.startIndex + y * complexC.stride;
            int x = 0;
            while (x < realA.width) {
                double real = realA.data[indexA];
                double realB = complexB.data[indexB];
                double imgB = complexB.data[indexB + 1];
                complexC.data[indexC] = real * realB;
                complexC.data[indexC + 1] = real * imgB;
                ++x;
                ++indexA;
                indexB += 2;
                indexC += 2;
            }
        }
    }

    public static void multiplyComplex(InterleavedF32 complexA, InterleavedF32 complexB, InterleavedF32 complexC) {
        InputSanityCheck.checkSameShape(complexA, complexB, complexC);
        for (int y = 0; y < complexA.height; ++y) {
            int indexA = complexA.startIndex + y * complexA.stride;
            int indexB = complexB.startIndex + y * complexB.stride;
            int indexC = complexC.startIndex + y * complexC.stride;
            int x = 0;
            while (x < complexA.width) {
                float realA = complexA.data[indexA];
                float imgA = complexA.data[indexA + 1];
                float realB = complexB.data[indexB];
                float imgB = complexB.data[indexB + 1];
                complexC.data[indexC] = realA * realB - imgA * imgB;
                complexC.data[indexC + 1] = realA * imgB + imgA * realB;
                ++x;
                indexA += 2;
                indexB += 2;
                indexC += 2;
            }
        }
    }

    public static void multiplyComplex(InterleavedF64 complexA, InterleavedF64 complexB, InterleavedF64 complexC) {
        InputSanityCheck.checkSameShape(complexA, complexB, complexC);
        for (int y = 0; y < complexA.height; ++y) {
            int indexA = complexA.startIndex + y * complexA.stride;
            int indexB = complexB.startIndex + y * complexB.stride;
            int indexC = complexC.startIndex + y * complexC.stride;
            int x = 0;
            while (x < complexA.width) {
                double realA = complexA.data[indexA];
                double imgA = complexA.data[indexA + 1];
                double realB = complexB.data[indexB];
                double imgB = complexB.data[indexB + 1];
                complexC.data[indexC] = realA * realB - imgA * imgB;
                complexC.data[indexC + 1] = realA * imgB + imgA * realB;
                ++x;
                indexA += 2;
                indexB += 2;
                indexC += 2;
            }
        }
    }
}

