/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.tracker.tld.TldFernDescription;
import boofcv.alg.tracker.tld.TldFernFeature;
import boofcv.alg.tracker.tld.TldFernManager;
import boofcv.alg.tracker.tld.TldRegionFernInfo;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;
import java.util.Random;

public class TldFernClassifier<T extends ImageGray> {
    protected int maxP = 0;
    protected int maxN = 0;
    private Random rand;
    private int numLearnRandom;
    private float fernLearnNoise;
    protected TldFernDescription[] ferns;
    protected TldFernManager[] managers;
    private InterpolatePixelS<T> interpolate;

    public TldFernClassifier(Random rand, int numFerns, int descriptorSize, int numLearnRandom, float fernLearnNoise, InterpolatePixelS<T> interpolate) {
        this.rand = rand;
        this.interpolate = interpolate;
        this.numLearnRandom = numLearnRandom;
        this.fernLearnNoise = fernLearnNoise;
        this.ferns = new TldFernDescription[numFerns];
        this.managers = new TldFernManager[numFerns];
        for (int i = 0; i < numFerns; ++i) {
            this.ferns[i] = new TldFernDescription(rand, descriptorSize);
            this.managers[i] = new TldFernManager(descriptorSize);
        }
    }

    protected TldFernClassifier() {
    }

    public void reset() {
        for (int i = 0; i < this.managers.length; ++i) {
            this.managers[i].reset();
        }
    }

    public void setImage(T gray) {
        this.interpolate.setImage(gray);
    }

    public void learnFern(boolean positive, ImageRectangle r) {
        float rectWidth = r.getWidth();
        float rectHeight = r.getHeight();
        float c_x = (float)r.x0 + (rectWidth - 1.0f) / 2.0f;
        float c_y = (float)r.y0 + (rectHeight - 1.0f) / 2.0f;
        for (int i = 0; i < this.ferns.length; ++i) {
            int value = this.computeFernValue(c_x, c_y, rectWidth, rectHeight, this.ferns[i]);
            TldFernFeature f = this.managers[i].lookupFern(value);
            this.increment(f, positive);
        }
    }

    public void learnFernNoise(boolean positive, ImageRectangle r) {
        float rectWidth = r.getWidth();
        float rectHeight = r.getHeight();
        float c_x = (float)r.x0 + (rectWidth - 1.0f) / 2.0f;
        float c_y = (float)r.y0 + (rectHeight - 1.0f) / 2.0f;
        for (int i = 0; i < this.ferns.length; ++i) {
            int value = this.computeFernValue(c_x, c_y, rectWidth, rectHeight, this.ferns[i]);
            TldFernFeature f = this.managers[i].lookupFern(value);
            this.increment(f, positive);
            for (int j = 0; j < this.numLearnRandom; ++j) {
                value = this.computeFernValueRand(c_x, c_y, rectWidth, rectHeight, this.ferns[i]);
                f = this.managers[i].lookupFern(value);
                this.increment(f, positive);
            }
        }
    }

    private void increment(TldFernFeature f, boolean positive) {
        if (positive) {
            f.incrementP();
            if (f.numP > this.maxP) {
                this.maxP = f.numP;
            }
        } else {
            f.incrementN();
            if (f.numN > this.maxN) {
                this.maxN = f.numN;
            }
        }
    }

    public boolean lookupFernPN(TldRegionFernInfo info) {
        ImageRectangle r = info.r;
        float rectWidth = r.getWidth();
        float rectHeight = r.getHeight();
        float c_x = (float)r.x0 + (rectWidth - 1.0f) / 2.0f;
        float c_y = (float)r.y0 + (rectHeight - 1.0f) / 2.0f;
        int sumP = 0;
        int sumN = 0;
        for (int i = 0; i < this.ferns.length; ++i) {
            TldFernDescription fern = this.ferns[i];
            int value = this.computeFernValue(c_x, c_y, rectWidth, rectHeight, fern);
            TldFernFeature f = this.managers[i].table[value];
            if (f == null) continue;
            sumP += f.numP;
            sumN += f.numN;
        }
        info.sumP = sumP;
        info.sumN = sumN;
        return sumN != 0 || sumP != 0;
    }

    protected int computeFernValue(float c_x, float c_y, float rectWidth, float rectHeight, TldFernDescription fern) {
        rectWidth -= 1.0f;
        rectHeight -= 1.0f;
        int desc = 0;
        for (int i = 0; i < fern.pairs.length; ++i) {
            Point2D_F32 p_a = fern.pairs[i].a;
            Point2D_F32 p_b = fern.pairs[i].b;
            float valA = this.interpolate.get_fast(c_x + p_a.x * rectWidth, c_y + p_a.y * rectHeight);
            float valB = this.interpolate.get_fast(c_x + p_b.x * rectWidth, c_y + p_b.y * rectHeight);
            desc *= 2;
            if (!(valA < valB)) continue;
            ++desc;
        }
        return desc;
    }

    protected int computeFernValueRand(float c_x, float c_y, float rectWidth, float rectHeight, TldFernDescription fern) {
        rectWidth -= 1.0f;
        rectHeight -= 1.0f;
        int desc = 0;
        for (int i = 0; i < fern.pairs.length; ++i) {
            Point2D_F32 p_a = fern.pairs[i].a;
            Point2D_F32 p_b = fern.pairs[i].b;
            float valA = this.interpolate.get_fast(c_x + p_a.x * rectWidth, c_y + p_a.y * rectHeight);
            float valB = this.interpolate.get_fast(c_x + p_b.x * rectWidth, c_y + p_b.y * rectHeight);
            valA = (float)((double)valA + this.rand.nextGaussian() * (double)this.fernLearnNoise);
            valB = (float)((double)valB + this.rand.nextGaussian() * (double)this.fernLearnNoise);
            desc *= 2;
            if (!(valA < valB)) continue;
            ++desc;
        }
        return desc;
    }

    public void renormalizeP() {
        int targetMax = this.maxP / 20;
        for (int i = 0; i < this.managers.length; ++i) {
            TldFernManager m = this.managers[i];
            for (int j = 0; j < m.table.length; ++j) {
                TldFernFeature f = m.table[j];
                if (f == null) continue;
                f.numP = targetMax * f.numP / this.maxP;
            }
        }
        this.maxP = targetMax;
    }

    public void renormalizeN() {
        int targetMax = this.maxN / 20;
        for (int i = 0; i < this.managers.length; ++i) {
            TldFernManager m = this.managers[i];
            for (int j = 0; j < m.table.length; ++j) {
                TldFernFeature f = m.table[j];
                if (f == null) continue;
                f.numN = targetMax * f.numN / this.maxN;
            }
        }
        this.maxN = targetMax;
    }

    public int getMaxP() {
        return this.maxP;
    }

    public int getMaxN() {
        return this.maxN;
    }
}

