/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.klt;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.tracker.klt.KltConfig;
import boofcv.alg.tracker.klt.KltFeature;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class KltTracker<InputImage extends ImageGray, DerivativeImage extends ImageGray> {
    protected InputImage image;
    protected DerivativeImage derivX;
    protected DerivativeImage derivY;
    protected InterpolateRectangle<InputImage> interpInput;
    protected InterpolateRectangle<DerivativeImage> interpDeriv;
    protected KltConfig config;
    protected float Gxx;
    protected float Gyy;
    protected float Gxy;
    protected float Ex;
    protected float Ey;
    protected int widthFeature;
    protected int lengthFeature;
    protected GrayF32 currDesc = new GrayF32(1, 1);
    protected GrayF32 subimage = new GrayF32();
    int dstX0;
    int dstY0;
    int dstX1;
    int dstY1;
    float srcX0;
    float srcY0;
    float allowedLeft;
    float allowedRight;
    float allowedTop;
    float allowedBottom;
    float outsideLeft;
    float outsideRight;
    float outsideTop;
    float outsideBottom;
    float error;

    public KltTracker(InterpolateRectangle<InputImage> interpInput, InterpolateRectangle<DerivativeImage> interpDeriv, KltConfig config) {
        this.interpInput = interpInput;
        this.interpDeriv = interpDeriv;
        this.config = config;
    }

    public void setImage(InputImage image, DerivativeImage derivX, DerivativeImage derivY) {
        InputSanityCheck.checkSameShape(image, derivX, derivY);
        this.image = image;
        this.interpInput.setImage(image);
        this.derivX = derivX;
        this.derivY = derivY;
    }

    public void unsafe_setImage(InputImage image, DerivativeImage derivX, DerivativeImage derivY) {
        this.image = image;
        this.interpInput.setImage(image);
        this.derivX = derivX;
        this.derivY = derivY;
    }

    public boolean setDescription(KltFeature feature) {
        this.setAllowedBounds(feature);
        if (!this.isFullyInside(feature.x, feature.y)) {
            if (this.isFullyOutside(feature.x, feature.y)) {
                return false;
            }
            return this.internalSetDescriptionBorder(feature);
        }
        return this.internalSetDescription(feature);
    }

    protected boolean internalSetDescription(KltFeature feature) {
        int regionWidth = feature.radius * 2 + 1;
        int size = regionWidth * regionWidth;
        float tl_x = feature.x - (float)feature.radius;
        float tl_y = feature.y - (float)feature.radius;
        this.interpInput.setImage(this.image);
        this.interpInput.region(tl_x, tl_y, feature.desc);
        this.interpDeriv.setImage(this.derivX);
        this.interpDeriv.region(tl_x, tl_y, feature.derivX);
        this.interpDeriv.setImage(this.derivY);
        this.interpDeriv.region(tl_x, tl_y, feature.derivY);
        float Gxx = 0.0f;
        float Gyy = 0.0f;
        float Gxy = 0.0f;
        for (int i = 0; i < size; ++i) {
            float dX = feature.derivX.data[i];
            float dY = feature.derivY.data[i];
            Gxx += dX * dX;
            Gyy += dY * dY;
            Gxy += dX * dY;
        }
        feature.Gxx = Gxx;
        feature.Gyy = Gyy;
        feature.Gxy = Gxy;
        float det = Gxx * Gyy - Gxy * Gxy;
        return det >= this.config.minDeterminant * (float)this.lengthFeature;
    }

    protected boolean internalSetDescriptionBorder(KltFeature feature) {
        this.computeSubImageBounds(feature, feature.x, feature.y);
        ImageMiscOps.fill(feature.desc, Float.NaN);
        feature.desc.subimage(this.dstX0, this.dstY0, this.dstX1, this.dstY1, this.subimage);
        this.interpInput.setImage(this.image);
        this.interpInput.region(this.srcX0, this.srcY0, this.subimage);
        feature.derivX.subimage(this.dstX0, this.dstY0, this.dstX1, this.dstY1, this.subimage);
        this.interpDeriv.setImage(this.derivX);
        this.interpDeriv.region(this.srcX0, this.srcY0, this.subimage);
        feature.derivY.subimage(this.dstX0, this.dstY0, this.dstX1, this.dstY1, this.subimage);
        this.interpDeriv.setImage(this.derivY);
        this.interpDeriv.region(this.srcX0, this.srcY0, this.subimage);
        int total = 0;
        this.Gxy = 0.0f;
        this.Gyy = 0.0f;
        this.Gxx = 0.0f;
        for (int i = 0; i < this.lengthFeature; ++i) {
            if (Float.isNaN(feature.desc.data[i])) continue;
            ++total;
            float dX = feature.derivX.data[i];
            float dY = feature.derivY.data[i];
            this.Gxx += dX * dX;
            this.Gyy += dY * dY;
            this.Gxy += dX * dY;
        }
        feature.Gxx = this.Gxx;
        feature.Gyy = this.Gyy;
        feature.Gxy = this.Gxy;
        float det = this.Gxx * this.Gyy - this.Gxy * this.Gxy;
        return det >= this.config.minDeterminant * (float)total;
    }

    public KltTrackFault track(KltFeature feature) {
        float f;
        this.setAllowedBounds(feature);
        if (this.isFullyOutside(feature.x, feature.y)) {
            return KltTrackFault.OUT_OF_BOUNDS;
        }
        if (this.currDesc.data.length < this.lengthFeature) {
            this.currDesc.reshape(this.widthFeature, this.widthFeature);
        }
        float origX = feature.x;
        float origY = feature.y;
        boolean complete = this.isDescriptionComplete(feature);
        float det = 0.0f;
        if (complete) {
            this.Gxx = feature.Gxx;
            this.Gyy = feature.Gyy;
            this.Gxy = feature.Gxy;
            det = this.Gxx * this.Gyy - this.Gxy * this.Gxy;
            if (det < this.config.minDeterminant * (float)this.lengthFeature) {
                return KltTrackFault.FAILED;
            }
        }
        for (int iter = 0; iter < this.config.maxIterations; ++iter) {
            if (complete && this.isFullyInside(feature.x, feature.y)) {
                this.computeE(feature, feature.x, feature.y);
            } else {
                det = this.Gxx * this.Gyy - this.Gxy * this.Gxy;
                int length = this.computeGandE_border(feature, feature.x, feature.y);
                if (det <= this.config.minDeterminant * (float)length) {
                    return KltTrackFault.FAILED;
                }
            }
            float dx = (this.Gyy * this.Ex - this.Gxy * this.Ey) / det;
            float dy = (this.Gxx * this.Ey - this.Gxy * this.Ex) / det;
            feature.x += dx;
            feature.y += dy;
            if (this.isFullyOutside(feature.x, feature.y)) {
                return KltTrackFault.OUT_OF_BOUNDS;
            }
            if (Math.abs(feature.x - origX) > (float)this.widthFeature || Math.abs(feature.y - origY) > (float)this.widthFeature) {
                return KltTrackFault.DRIFTED;
            }
            if (Math.abs(dx) < this.config.minPositionDelta && Math.abs(dy) < this.config.minPositionDelta) break;
        }
        this.error = this.computeError(feature);
        if (f > this.config.maxPerPixelError) {
            return KltTrackFault.LARGE_ERROR;
        }
        return KltTrackFault.SUCCESS;
    }

    protected void setAllowedBounds(KltFeature feature) {
        this.widthFeature = feature.radius * 2 + 1;
        this.lengthFeature = this.widthFeature * this.widthFeature;
        this.allowedLeft = feature.radius;
        this.allowedTop = feature.radius;
        this.allowedRight = ((ImageGray)this.image).width - feature.radius - 1;
        this.allowedBottom = ((ImageGray)this.image).height - feature.radius - 1;
        this.outsideLeft = -feature.radius;
        this.outsideTop = -feature.radius;
        this.outsideRight = ((ImageGray)this.image).width + feature.radius - 1;
        this.outsideBottom = ((ImageGray)this.image).height + feature.radius - 1;
    }

    private float computeError(KltFeature feature) {
        float error = 0.0f;
        int total = 0;
        for (int i = 0; i < this.lengthFeature; ++i) {
            if (Float.isNaN(feature.desc.data[i]) || Float.isNaN(this.currDesc.data[i])) continue;
            error += Math.abs(feature.desc.data[i] - this.currDesc.data[i]);
            ++total;
        }
        return error / (float)total;
    }

    protected void computeE(KltFeature feature, float x, float y) {
        this.interpInput.region(x - (float)feature.radius, y - (float)feature.radius, this.currDesc);
        this.Ex = 0.0f;
        this.Ey = 0.0f;
        for (int i = 0; i < this.lengthFeature; ++i) {
            float d = feature.desc.data[i] - this.currDesc.data[i];
            this.Ex += d * feature.derivX.data[i];
            this.Ey += d * feature.derivY.data[i];
        }
    }

    protected int computeGandE_border(KltFeature feature, float cx, float cy) {
        this.computeSubImageBounds(feature, cx, cy);
        ImageMiscOps.fill(this.currDesc, Float.NaN);
        this.currDesc.subimage(this.dstX0, this.dstY0, this.dstX1, this.dstY1, this.subimage);
        this.interpInput.setImage(this.image);
        this.interpInput.region(this.srcX0, this.srcY0, this.subimage);
        int total = 0;
        this.Gxx = 0.0f;
        this.Gyy = 0.0f;
        this.Gxy = 0.0f;
        this.Ex = 0.0f;
        this.Ey = 0.0f;
        for (int i = 0; i < this.lengthFeature; ++i) {
            float template = feature.desc.data[i];
            float current = this.currDesc.data[i];
            if (Float.isNaN(template) || Float.isNaN(current)) continue;
            ++total;
            float dX = feature.derivX.data[i];
            float dY = feature.derivY.data[i];
            float d = template - current;
            this.Ex += d * dX;
            this.Ey += d * dY;
            this.Gxx += dX * dX;
            this.Gyy += dY * dY;
            this.Gxy += dX * dY;
        }
        return total;
    }

    private void computeSubImageBounds(KltFeature feature, float cx, float cy) {
        this.dstX0 = 0;
        this.dstY0 = 0;
        this.dstX1 = this.widthFeature;
        this.dstY1 = this.widthFeature;
        this.srcX0 = cx - (float)feature.radius;
        this.srcY0 = cy - (float)feature.radius;
        float srxX1 = this.srcX0 + (float)this.widthFeature;
        float srxY1 = this.srcY0 + (float)this.widthFeature;
        if (this.srcX0 < 0.0f) {
            this.dstX0 = (int)(-Math.floor(this.srcX0));
            this.srcX0 += (float)this.dstX0;
        }
        if (srxX1 > (float)((ImageGray)this.image).width) {
            this.dstX1 -= (int)Math.ceil(srxX1 - (float)((ImageGray)this.image).width);
            this.dstX1 -= this.srcX0 + (float)(this.dstX1 - this.dstX0) > (float)((ImageGray)this.image).width ? 1 : 0;
        }
        if (this.srcY0 < 0.0f) {
            this.dstY0 = (int)(-Math.floor(this.srcY0));
            this.srcY0 += (float)this.dstY0;
        }
        if (srxY1 > (float)((ImageGray)this.image).height) {
            this.dstY1 -= (int)Math.ceil(srxY1 - (float)((ImageGray)this.image).height);
            this.dstY1 -= this.srcY0 + (float)(this.dstY1 - this.dstY0) > (float)((ImageGray)this.image).height ? 1 : 0;
        }
        if (this.srcX0 < 0.0f || this.srcY0 < 0.0f || this.srcX0 + (float)(this.dstX1 - this.dstX0) > (float)((ImageGray)this.image).width || this.srcY0 + (float)(this.dstY1 - this.dstY0) > (float)((ImageGray)this.image).height) {
            throw new IllegalArgumentException("Region is outside of the image");
        }
    }

    public boolean isDescriptionComplete(KltFeature feature) {
        for (int i = 0; i < this.lengthFeature; ++i) {
            if (!Float.isNaN(feature.desc.data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyInside(float x, float y) {
        if (x < this.allowedLeft || x > this.allowedRight) {
            return false;
        }
        return !(y < this.allowedTop) && !(y > this.allowedBottom);
    }

    public boolean isFullyOutside(float x, float y) {
        if (x < this.outsideLeft || x > this.outsideRight) {
            return true;
        }
        return y < this.outsideTop || y > this.outsideBottom;
    }

    public float getError() {
        return this.error;
    }

    public KltConfig getConfig() {
        return this.config;
    }
}

