/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polyline;

import boofcv.misc.CircularIndex;
import georegression.geometry.UtilLine2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.GrowQueue_I32;

public class RefinePolyLineCorner {
    private int maxIterations = 10;
    private final int maxLineSamples = 20;
    protected int searchRadius;
    private LineSegment2D_F64 work = new LineSegment2D_F64();
    LineGeneral2D_F64 line0 = new LineGeneral2D_F64();
    LineGeneral2D_F64 line1 = new LineGeneral2D_F64();
    boolean looping;

    public RefinePolyLineCorner(boolean looping, int maxIterations) {
        this.looping = looping;
        this.maxIterations = maxIterations;
    }

    public RefinePolyLineCorner(boolean looping) {
        this.looping = looping;
    }

    public boolean fit(List<Point2D_I32> contour, GrowQueue_I32 corners) {
        int endCorner;
        int startCorner;
        if (corners.size() < 3) {
            return false;
        }
        this.searchRadius = Math.min(6, Math.max(contour.size() / 12, 3));
        if (this.looping) {
            startCorner = 0;
            endCorner = corners.size;
        } else {
            startCorner = 1;
            endCorner = corners.size - 1;
        }
        boolean change = true;
        for (int iteration = 0; iteration < this.maxIterations && change; ++iteration) {
            change = false;
            for (int i = startCorner; i < endCorner; ++i) {
                int c0 = CircularIndex.minusPOffset(i, 1, corners.size());
                int c2 = CircularIndex.plusPOffset(i, 1, corners.size());
                int improved = this.optimize(contour, corners.get(c0), corners.get(i), corners.get(c2));
                if (improved == corners.get(i)) continue;
                corners.set(i, improved);
                change = true;
            }
        }
        return true;
    }

    protected int optimize(List<Point2D_I32> contour, int c0, int c1, int c2) {
        double bestDistance = this.computeCost(contour, c0, c1, c2, 0);
        int bestIndex = 0;
        for (int i = -this.searchRadius; i <= this.searchRadius; ++i) {
            if (i == 0) {
                if (bestIndex == 0) continue;
                break;
            }
            double found = this.computeCost(contour, c0, c1, c2, i);
            if (!(found < bestDistance)) continue;
            bestDistance = found;
            bestIndex = i;
        }
        return CircularIndex.addOffset(c1, bestIndex, contour.size());
    }

    protected double computeCost(List<Point2D_I32> contour, int c0, int c1, int c2, int offset) {
        c1 = CircularIndex.addOffset(c1, offset, contour.size());
        this.createLine(c0, c1, contour, this.line0);
        this.createLine(c1, c2, contour, this.line1);
        return this.distanceSum(this.line0, c0, c1, contour) + this.distanceSum(this.line1, c1, c2, contour);
    }

    protected double distanceSum(LineGeneral2D_F64 line, int c0, int c1, List<Point2D_I32> contour) {
        double total = 0.0;
        if (c0 < c1) {
            int length = c1 - c0 + 1;
            int samples = Math.min(20, length);
            for (int i = 0; i < samples; ++i) {
                int index = c0 + i * (length - 1) / (samples - 1);
                total += RefinePolyLineCorner.distance(line, contour.get(index));
            }
        } else {
            int index;
            int i;
            int lengthFirst = contour.size() - c0;
            int lengthSecond = c1 + 1;
            int length = lengthFirst + c1 + 1;
            int samples = Math.min(20, length);
            int samplesFirst = samples * lengthFirst / length;
            int samplesSecond = samples * lengthSecond / length;
            for (i = 0; i < samplesFirst; ++i) {
                index = c0 + i * lengthFirst / (samples - 1);
                total += RefinePolyLineCorner.distance(line, contour.get(index));
            }
            for (i = 0; i < samplesSecond; ++i) {
                index = i * lengthSecond / (samples - 1);
                total += RefinePolyLineCorner.distance(line, contour.get(index));
            }
        }
        return total;
    }

    protected static double distance(LineGeneral2D_F64 line, Point2D_I32 p) {
        return Math.abs(line.A * (double)p.x + line.B * (double)p.y + line.C);
    }

    private void createLine(int index0, int index1, List<Point2D_I32> contour, LineGeneral2D_F64 line) {
        if (index1 < 0) {
            System.out.println("SHIT");
        }
        Point2D_I32 p0 = contour.get(index0);
        Point2D_I32 p1 = contour.get(index1);
        this.work.a.set((double)p0.x, (double)p0.y);
        this.work.b.set((double)p1.x, (double)p1.y);
        UtilLine2D_F64.convert((LineSegment2D_F64)this.work, (LineGeneral2D_F64)line);
        line.normalize();
    }
}

