/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d2;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.alg.sfm.d2.AssociatedPairTrack;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelMatcher;

public class ImageMotionPointTrackerKey<I extends ImageBase, IT extends InvertibleTransform> {
    protected int totalFramesProcessed = 0;
    protected PointTracker<I> tracker;
    protected ModelMatcher<IT, AssociatedPair> modelMatcher;
    protected ModelFitter<IT, AssociatedPair> modelRefiner;
    protected IT worldToKey;
    protected IT keyToCurr;
    protected IT worldToCurr;
    protected int outlierPrune;
    protected boolean keyFrame;

    public ImageMotionPointTrackerKey(PointTracker<I> tracker, ModelMatcher<IT, AssociatedPair> modelMatcher, ModelFitter<IT, AssociatedPair> modelRefiner, IT model, int outlierPrune) {
        this.tracker = tracker;
        this.modelMatcher = modelMatcher;
        this.modelRefiner = modelRefiner;
        this.outlierPrune = outlierPrune;
        this.worldToKey = model.createInstance();
        this.keyToCurr = model.createInstance();
        this.worldToCurr = model.createInstance();
    }

    protected ImageMotionPointTrackerKey() {
    }

    public void reset() {
        this.totalFramesProcessed = 0;
        this.tracker.dropAllTracks();
        this.resetTransforms();
    }

    public boolean process(I frame) {
        this.keyFrame = false;
        this.tracker.process(frame);
        ++this.totalFramesProcessed;
        List<PointTrack> tracks = this.tracker.getActiveTracks(null);
        if (tracks.size() == 0) {
            return false;
        }
        ArrayList<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
        for (PointTrack t : tracks) {
            pairs.add((AssociatedPair)t.getCookie());
        }
        if (!this.modelMatcher.process(pairs)) {
            return false;
        }
        if (this.modelRefiner != null) {
            if (!this.modelRefiner.fitModel(this.modelMatcher.getMatchSet(), this.modelMatcher.getModelParameters(), this.keyToCurr)) {
                return false;
            }
        } else {
            this.keyToCurr.set((InvertibleTransform)this.modelMatcher.getModelParameters());
        }
        for (AssociatedPair p : this.modelMatcher.getMatchSet()) {
            ((AssociatedPairTrack)p).lastUsed = this.totalFramesProcessed;
        }
        this.pruneUnusedTracks();
        this.worldToKey.concat(this.keyToCurr, this.worldToCurr);
        return true;
    }

    private void pruneUnusedTracks() {
        List<PointTrack> all = this.tracker.getAllTracks(null);
        for (PointTrack t : all) {
            AssociatedPairTrack p = (AssociatedPairTrack)t.getCookie();
            if ((long)this.totalFramesProcessed - p.lastUsed < (long)this.outlierPrune || this.tracker.dropTrack(t)) continue;
            throw new RuntimeException("Drop track failed. Must be a bug in the tracker");
        }
    }

    public void changeKeyFrame() {
        List<PointTrack> inactive = this.tracker.getInactiveTracks(null);
        for (PointTrack pointTrack : inactive) {
            this.tracker.dropTrack(pointTrack);
        }
        List<PointTrack> active = this.tracker.getActiveTracks(null);
        for (PointTrack l : active) {
            AssociatedPairTrack p = (AssociatedPairTrack)l.getCookie();
            p.p1.set((Point2D_F64)l);
            p.lastUsed = this.totalFramesProcessed;
        }
        this.tracker.spawnTracks();
        List<PointTrack> list = this.tracker.getNewTracks(null);
        for (PointTrack l : list) {
            AssociatedPairTrack p = (AssociatedPairTrack)l.getCookie();
            if (p == null) {
                p = new AssociatedPairTrack();
                l.cookie = p;
                p.p2 = l;
            }
            p.p1.set((Point2D_F64)l);
            p.lastUsed = this.totalFramesProcessed;
        }
        this.worldToKey.set(this.worldToCurr);
        this.keyToCurr.reset();
        this.keyFrame = true;
    }

    public void resetTransforms() {
        this.worldToCurr.reset();
        this.worldToKey.reset();
        this.keyToCurr.reset();
    }

    public IT getWorldToCurr() {
        return this.worldToCurr;
    }

    public IT getWorldToKey() {
        return this.worldToKey;
    }

    public IT getKeyToCurr() {
        return this.keyToCurr;
    }

    public PointTracker<I> getTracker() {
        return this.tracker;
    }

    public ModelMatcher<IT, AssociatedPair> getModelMatcher() {
        return this.modelMatcher;
    }

    public int getTotalFramesProcessed() {
        return this.totalFramesProcessed;
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    public Class<IT> getModelType() {
        return this.keyToCurr.getClass();
    }
}

