/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.struct.geo.GeoModelEstimator1;
import boofcv.struct.geo.GeoModelEstimatorN;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.struct.FastQueue;

public class PnPStereoEstimator
implements GeoModelEstimator1<Se3_F64, Stereo2D3D> {
    private GeoModelEstimatorN<Se3_F64, Point2D3D> alg;
    private DistanceFromModel<Se3_F64, Point2D3D> distance;
    private FastQueue<Point2D3D> monoPoints = new FastQueue(10, Point2D3D.class, true);
    private Se3_F64 leftToRight = new Se3_F64();
    private Se3_F64 worldToRight = new Se3_F64();
    private FastQueue<Se3_F64> solutions = new FastQueue(4, Se3_F64.class, true);
    int extraForTest;

    public PnPStereoEstimator(GeoModelEstimatorN<Se3_F64, Point2D3D> alg, DistanceFromModel<Se3_F64, Point2D3D> distance, int extraForTest) {
        this.alg = alg;
        this.distance = distance;
        this.extraForTest = extraForTest;
    }

    public void setLeftToRight(Se3_F64 leftToRight) {
        this.leftToRight = leftToRight;
    }

    @Override
    public boolean process(List<Stereo2D3D> points, Se3_F64 estimatedModel) {
        int N = this.alg.getMinimumPoints();
        this.monoPoints.reset();
        for (int i = 0; i < N; ++i) {
            Stereo2D3D s = points.get(i);
            Point2D3D p = (Point2D3D)this.monoPoints.grow();
            p.observation = s.leftObs;
            p.location = s.location;
        }
        this.solutions.reset();
        this.alg.process(this.monoPoints.toList(), this.solutions);
        Point2D3D p = (Point2D3D)this.monoPoints.get(0);
        Se3_F64 bestMotion = null;
        double bestError = Double.MAX_VALUE;
        for (int i = 0; i < this.solutions.size; ++i) {
            Stereo2D3D s;
            int j;
            Se3_F64 worldToLeft = ((Se3_F64[])this.solutions.data)[i];
            double totalError = 0.0;
            this.distance.setModel((Object)worldToLeft);
            for (j = N; j < points.size(); ++j) {
                s = points.get(i);
                p.observation = s.leftObs;
                p.location = s.location;
                totalError += this.distance.computeDistance((Object)p);
            }
            worldToLeft.concat(this.leftToRight, this.worldToRight);
            this.distance.setModel((Object)this.worldToRight);
            for (j = 0; j < points.size(); ++j) {
                s = points.get(j);
                p.observation = s.rightObs;
                p.location = s.location;
                totalError += this.distance.computeDistance((Object)p);
            }
            if (!(totalError < bestError)) continue;
            bestError = totalError;
            bestMotion = worldToLeft;
        }
        if (bestMotion == null) {
            return false;
        }
        estimatedModel.set(bestMotion);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return this.alg.getMinimumPoints() + this.extraForTest;
    }
}

