/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;

public class ImplConvolveBox {
    public static void horizontal(GrayU8 input, GrayI16 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = (short)total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFF;
                output.data[indexOut++] = (short)(total += input.data[indexIn] & 0xFF);
                ++indexIn;
            }
        }
    }

    public static void vertical(GrayU8 input, GrayI16 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut] = (short)total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int total = output.data[indexOut - output.stride] - (input.data[indexIn - backStep] & 0xFF);
                output.data[indexOut] = (short)(total += input.data[indexIn] & 0xFF);
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(GrayU8 input, GrayS32 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFF;
                output.data[indexOut++] = total += input.data[indexIn] & 0xFF;
                ++indexIn;
            }
        }
    }

    public static void vertical(GrayU8 input, GrayS32 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut] = total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int total = output.data[indexOut - output.stride] - (input.data[indexIn - backStep] & 0xFF);
                output.data[indexOut] = total += input.data[indexIn] & 0xFF;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = (short)total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = (short)(total += input.data[indexIn]);
                ++indexIn;
            }
        }
    }

    public static void vertical(GrayS16 input, GrayI16 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            output.data[indexOut] = (short)total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int total = output.data[indexOut - output.stride] - input.data[indexIn - backStep];
                output.data[indexOut] = (short)(total += input.data[indexIn]);
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(GrayS32 input, GrayS32 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = total += input.data[indexIn];
                ++indexIn;
            }
        }
    }

    public static void vertical(GrayS32 input, GrayS32 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            output.data[indexOut] = total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int total = output.data[indexOut - output.stride] - input.data[indexIn - backStep];
                output.data[indexOut] = total += input.data[indexIn];
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(GrayF32 input, GrayF32 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            float total = 0.0f;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = total += input.data[indexIn];
                ++indexIn;
            }
        }
    }

    public static void vertical(GrayF32 input, GrayF32 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            float total = 0.0f;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            output.data[indexOut] = total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                float total = output.data[indexOut - output.stride] - input.data[indexIn - backStep];
                output.data[indexOut] = total += input.data[indexIn];
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(GrayF64 input, GrayF64 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            double total = 0.0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = total += input.data[indexIn];
                ++indexIn;
            }
        }
    }

    public static void vertical(GrayF64 input, GrayF64 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            double total = 0.0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            output.data[indexOut] = total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                double total = output.data[indexOut - output.stride] - input.data[indexIn - backStep];
                output.data[indexOut] = total += input.data[indexIn];
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }
}

