/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.alg.filter.convolve.noborder.ImplConvolveMean;
import boofcv.alg.filter.convolve.normalized.ConvolveNormalized_JustBorder;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class ConvolveImageMean {
    public static void horizontal(GrayF32 input, GrayF32 output, int radius) {
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, true);
        if (kernel.width > input.width) {
            ConvolveNormalized.horizontal(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.horizontal(kernel, input, output);
            ImplConvolveMean.horizontal(input, output, radius);
        }
    }

    public static void vertical(GrayF32 input, GrayF32 output, int radius) {
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, true);
        if (kernel.width > input.height) {
            ConvolveNormalized.vertical(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.vertical(kernel, input, output);
            ImplConvolveMean.vertical(input, output, radius);
        }
    }

    public static void horizontal(GrayU8 input, GrayU8 output, int radius) {
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        if (kernel.width > input.width) {
            ConvolveNormalized.horizontal(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.horizontal(kernel, input, output);
            ImplConvolveMean.horizontal(input, output, radius);
        }
    }

    public static void vertical(GrayU8 input, GrayI8 output, int radius) {
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        if (kernel.width > input.height) {
            ConvolveNormalized.vertical(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.vertical(kernel, input, output);
            ImplConvolveMean.vertical(input, output, radius);
        }
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int radius) {
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        if (kernel.width > input.width) {
            ConvolveNormalized.horizontal(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.horizontal(kernel, input, output);
            ImplConvolveMean.horizontal(input, output, radius);
        }
    }

    public static void vertical(GrayS16 input, GrayI16 output, int radius) {
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        if (kernel.width > input.height) {
            ConvolveNormalized.vertical(kernel, input, output);
        } else {
            InputSanityCheck.checkSameShape(input, output);
            ConvolveNormalized_JustBorder.vertical(kernel, input, output);
            ImplConvolveMean.vertical(input, output, radius);
        }
    }
}

