/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import org.ddogleg.sorting.QuickSelect;

public class ImplMedianSortNaive {
    public static void process(GrayI input, GrayI output, int radius, int[] storage) {
        int w = 2 * radius + 1;
        if (storage == null) {
            storage = new int[w * w];
        } else if (storage.length < w * w) {
            throw new IllegalArgumentException("'storage' must be at least of length " + w * w);
        }
        for (int y = 0; y < input.height; ++y) {
            int minI = y - radius;
            int maxI = y + radius + 1;
            if (minI < 0) {
                minI = 0;
            }
            if (maxI > input.height) {
                maxI = input.height;
            }
            for (int x = 0; x < input.width; ++x) {
                int minJ = x - radius;
                int maxJ = x + radius + 1;
                if (minJ < 0) {
                    minJ = 0;
                }
                if (maxJ > input.width) {
                    maxJ = input.width;
                }
                int index = 0;
                for (int i = minI; i < maxI; ++i) {
                    for (int j = minJ; j < maxJ; ++j) {
                        storage[index++] = input.get(j, i);
                    }
                }
                int median = QuickSelect.select((int[])storage, (int)(index / 2), (int)index);
                output.set(x, y, median);
            }
        }
    }

    public static void process(GrayF32 input, GrayF32 output, int radius, float[] storage) {
        int w = 2 * radius + 1;
        if (storage == null) {
            storage = new float[w * w];
        } else if (storage.length < w * w) {
            throw new IllegalArgumentException("'storage' must be at least of length " + w * w);
        }
        for (int y = 0; y < input.height; ++y) {
            int minI = y - radius;
            int maxI = y + radius + 1;
            if (minI < 0) {
                minI = 0;
            }
            if (maxI > input.height) {
                maxI = input.height;
            }
            for (int x = 0; x < input.width; ++x) {
                int minJ = x - radius;
                int maxJ = x + radius + 1;
                if (minJ < 0) {
                    minJ = 0;
                }
                if (maxJ > input.width) {
                    maxJ = input.width;
                }
                int index = 0;
                for (int i = minI; i < maxI; ++i) {
                    for (int j = minJ; j < maxJ; ++j) {
                        storage[index++] = input.get(j, i);
                    }
                }
                float median = QuickSelect.select((float[])storage, (int)(index / 2), (int)index);
                output.set(x, y, median);
            }
        }
    }
}

