/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.calib.squares.SquaresIntoClusters;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;

public class SquaresIntoCrossClusters
extends SquaresIntoClusters {
    public int maxNeighbors;
    double maxCornerDistance;
    double tooFarFraction = 0.3;
    private NearestNeighbor<SquareNode> search = FactoryNearestNeighbor.kdtree();
    private FastQueue<double[]> searchPoints;
    private List<SquareNode> searchSquareList = new ArrayList<SquareNode>();
    private FastQueue<NnData<SquareNode>> searchResults = new FastQueue(NnData.class, true);

    public SquaresIntoCrossClusters(double maxCornerDistance, int maxNeighbors) {
        this.maxCornerDistance = maxCornerDistance;
        int n = this.maxNeighbors = maxNeighbors > 0 ? maxNeighbors : Integer.MAX_VALUE;
        if (this.maxNeighbors == Integer.MAX_VALUE) {
            this.maxNeighbors = 0x7FFFFFFE;
        }
        this.searchPoints = new FastQueue<double[]>(double[].class, true){

            protected double[] createInstance() {
                return new double[2];
            }
        };
        this.search.init(2);
    }

    public List<List<SquareNode>> process(List<Polygon2D_F64> squares, List<BinaryPolygonDetector.Info> info) {
        this.recycleData();
        this.computeNodeInfo(squares, info);
        this.connectNodes();
        this.findClusters();
        return this.clusters.toList();
    }

    void computeNodeInfo(List<Polygon2D_F64> squares, List<BinaryPolygonDetector.Info> squaresInfo) {
        for (int i = 0; i < squares.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.grow();
            n.reset();
            Polygon2D_F64 polygon = squares.get(i);
            BinaryPolygonDetector.Info info = squaresInfo.get(i);
            if (info.borderCorners.size() > 0) {
                boolean allBorder = true;
                for (int j = 0; j < info.borderCorners.size(); ++j) {
                    if (info.borderCorners.get(j)) continue;
                    allBorder = false;
                    break;
                }
                if (allBorder) {
                    this.nodes.removeTail();
                    continue;
                }
            }
            UtilPoint2D_F64.mean((Point2D_F64[])((Point2D_F64[])polygon.vertexes.data), (int)0, (int)polygon.size(), (Point2D_F64)n.center);
            int j = 0;
            int k = polygon.size() - 1;
            while (j < polygon.size()) {
                double l = polygon.get(j).distance((GeoTuple2D_F64)polygon.get(k));
                n.largestSide = Math.max(n.largestSide, l);
                k = j++;
            }
            n.corners = polygon;
            n.touch = info.borderCorners;
            n.updateArrayLength();
        }
    }

    void connectNodes() {
        this.setupSearch();
        int indexCornerList = 0;
        for (int indexNode = 0; indexNode < this.nodes.size(); ++indexNode) {
            SquareNode n = (SquareNode)this.nodes.get(indexNode);
            for (int indexLocal = 0; indexLocal < n.corners.size(); ++indexLocal) {
                if (n.touch.size > 0 && n.touch.get(indexLocal)) continue;
                double[] point = (double[])this.searchPoints.get(indexCornerList++);
                this.searchResults.reset();
                this.search.findNearest(point, this.maxCornerDistance * this.maxCornerDistance, this.maxNeighbors + 1, this.searchResults);
                for (int indexResults = 0; indexResults < this.searchResults.size(); ++indexResults) {
                    NnData neighborData = (NnData)this.searchResults.get(indexResults);
                    SquareNode neighborNode = (SquareNode)neighborData.data;
                    if (neighborNode == n) continue;
                    int neighborCornerIndex = this.getCornerIndex(neighborNode, neighborData.point[0], neighborData.point[1]);
                    if (!this.candidateIsMuchCloser(n, neighborNode, neighborData.distance)) continue;
                    this.considerConnect(n, indexLocal, neighborNode, neighborCornerIndex, neighborData.distance);
                }
            }
        }
    }

    int getCornerIndex(SquareNode node, double x, double y) {
        for (int i = 0; i < node.corners.size(); ++i) {
            Point2D_F64 c = node.corners.get(i);
            if (c.x != x || c.y != y) continue;
            return i;
        }
        throw new RuntimeException("BUG!");
    }

    private void setupSearch() {
        this.searchPoints.reset();
        this.searchSquareList.clear();
        for (int i = 0; i < this.nodes.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.get(i);
            for (int j = 0; j < n.corners.size(); ++j) {
                if (n.touch.size > 0 && n.touch.get(j)) continue;
                Point2D_F64 c = n.corners.get(j);
                double[] point = (double[])this.searchPoints.grow();
                point[0] = c.x;
                point[1] = c.y;
                this.searchSquareList.add(n);
            }
        }
        this.search.setPoints(this.searchPoints.toList(), this.searchSquareList);
    }

    boolean candidateIsMuchCloser(SquareNode node0, SquareNode node1, double distance2) {
        double length = Math.max(node0.largestSide, node1.largestSide) * this.tooFarFraction;
        if (distance2 > (length *= length)) {
            return false;
        }
        return distance2 <= length;
    }

    void considerConnect(SquareNode node0, int corner0, SquareNode node1, int corner1, double distance) {
        if (node0.edges[corner0] != null && node0.edges[corner0].distance > distance) {
            this.detachEdge(node0.edges[corner0]);
        }
        if (node1.edges[corner1] != null && node1.edges[corner1].distance > distance) {
            this.detachEdge(node1.edges[corner1]);
        }
        if (node0.edges[corner0] == null && node1.edges[corner1] == null) {
            this.connect(node0, corner0, node1, corner1, distance);
        }
    }
}

