/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.alg.shapes.polygon.PolygonHelper;
import boofcv.alg.shapes.polygon.RefineBinaryPolygon;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class ChessboardPolygonHelper<T extends ImageGray>
implements PolygonHelper {
    BinaryPolygonDetector<T> detectorSquare;
    RefineBinaryPolygon<T> refineLine;
    RefineBinaryPolygon<T> refineCorner;
    double threshold = 400.0;
    int width;
    int height;
    FastQueue<Point2D_F64> tmp = new FastQueue(Point2D_F64.class, true);

    public ChessboardPolygonHelper(BinaryPolygonDetector<T> detectorSquare, RefineBinaryPolygon<T> refineLine, RefineBinaryPolygon<T> refineCorner) {
        this.detectorSquare = detectorSquare;
        this.refineLine = refineLine;
        this.refineCorner = refineCorner;
    }

    @Override
    public void setImageShape(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void adjustBeforeOptimize(Polygon2D_F64 polygon) {
        int i;
        int N = polygon.size();
        this.tmp.resize(N);
        for (i = 0; i < N; ++i) {
            ((Point2D_F64)this.tmp.get(i)).set(0.0, 0.0);
        }
        i = N - 1;
        int j = 0;
        while (j < N) {
            Point2D_F64 a = polygon.get(i);
            Point2D_F64 b = polygon.get(j);
            double dx = b.x - a.x;
            double dy = b.y - a.y;
            double l = Math.sqrt(dx * dx + dy * dy);
            Point2D_F64 _a = (Point2D_F64)this.tmp.get(i);
            Point2D_F64 _b = (Point2D_F64)this.tmp.get(j);
            _a.x -= (dx *= 1.3 / l);
            _a.y -= (dy *= 1.3 / l);
            _b.x += dx;
            _b.y += dy;
            i = j++;
        }
        for (i = 0; i < N; ++i) {
            Point2D_F64 a = polygon.get(i);
            Point2D_F64 t = (Point2D_F64)this.tmp.get(i);
            a.x += t.x;
            a.y += t.y;
            if (a.x < 0.0) {
                a.x = 0.0;
            } else if (a.x > (double)(this.width - 1)) {
                a.x = this.width - 1;
            }
            if (a.y < 0.0) {
                a.y = 0.0;
                continue;
            }
            if (!(a.y > (double)(this.height - 1))) continue;
            a.y = this.height - 1;
        }
        if (this.refineCorner != null) {
            double area = polygon.areaSimple();
            if (area < this.threshold) {
                this.detectorSquare.setRefinePolygon(this.refineLine);
            } else {
                this.detectorSquare.setRefinePolygon(this.refineCorner);
            }
        } else {
            this.detectorSquare.setRefinePolygon(this.refineLine);
        }
    }

    @Override
    public boolean filterContour(List<Point2D_I32> contour, boolean touchesBorder, boolean distorted) {
        return true;
    }

    @Override
    public boolean filterPixelPolygon(List<Point2D_I32> externalUndist, List<Point2D_I32> externalDist, GrowQueue_I32 splits, boolean touchesBorder) {
        if (touchesBorder) {
            if (splits.size() > 7 || splits.size() < 3) {
                return false;
            }
            int totalRegular = 0;
            for (int i = 0; i < splits.size(); ++i) {
                Point2D_I32 p = externalDist.get(splits.get(i));
                if (p.x == 0 || p.y == 0 || p.x == this.width - 1 || p.y == this.height - 1) continue;
                ++totalRegular;
            }
            return totalRegular > 0 && totalRegular <= 4;
        }
        return splits.size() == 4;
    }
}

