/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity;

import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.struct.image.ImageGray;

public abstract class SelectRectBasicWta<Array, Disparity extends ImageGray>
implements DisparitySelect<Array, Disparity> {
    protected Disparity imageDisparity;
    protected int minDisparity;
    protected int maxDisparity;
    protected int rangeDisparity;
    protected int radiusX;
    protected int regionWidth;
    protected int imageWidth;

    @Override
    public void configure(Disparity imageDisparity, int minDisparity, int maxDisparity, int radiusX) {
        this.imageDisparity = imageDisparity;
        this.minDisparity = minDisparity;
        this.maxDisparity = maxDisparity;
        this.radiusX = radiusX;
        this.rangeDisparity = maxDisparity - minDisparity;
        this.regionWidth = radiusX * 2 + 1;
        this.imageWidth = ((ImageGray)imageDisparity).width;
    }

    protected int maxDisparityAtColumnL2R(int col) {
        return 1 + col - this.minDisparity - Math.max(0, col - this.maxDisparity + 1);
    }
}

