/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.template;

import boofcv.alg.feature.detect.template.TemplateMatchingIntensity;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;

public abstract class BaseTemplateIntensity<T extends ImageBase>
implements TemplateMatchingIntensity<T> {
    private GrayF32 intensity = new GrayF32(1, 1);
    protected T image;
    protected T template;
    protected T mask;
    private int borderX0;
    private int borderY0;
    private int borderX1;
    private int borderY1;

    @Override
    public void process(T image, T template) {
        this.image = image;
        this.template = template;
        this.intensity.reshape(((ImageBase)image).width, ((ImageBase)image).height);
        int w = ((ImageBase)image).width - ((ImageBase)template).width;
        int h = ((ImageBase)image).height - ((ImageBase)template).height;
        this.borderX0 = ((ImageBase)template).width / 2;
        this.borderY0 = ((ImageBase)template).height / 2;
        this.borderX1 = ((ImageBase)template).width - this.borderX0;
        this.borderY1 = ((ImageBase)template).height - this.borderY0;
        for (int y = 0; y < h; ++y) {
            int index = this.intensity.startIndex + (y + this.borderY0) * this.intensity.stride + this.borderX0;
            for (int x = 0; x < w; ++x) {
                this.intensity.data[index++] = this.evaluate(x, y);
            }
        }
        this.image = null;
        this.template = null;
    }

    @Override
    public void process(T image, T template, T mask) {
        if (mask == null) {
            this.process(image, template);
            return;
        }
        this.image = image;
        this.template = template;
        this.mask = mask;
        this.intensity.reshape(((ImageBase)image).width, ((ImageBase)image).height);
        int w = ((ImageBase)image).width - ((ImageBase)template).width;
        int h = ((ImageBase)image).height - ((ImageBase)template).height;
        this.borderX0 = ((ImageBase)template).width / 2;
        this.borderY0 = ((ImageBase)template).height / 2;
        for (int y = 0; y < h; ++y) {
            int index = this.intensity.startIndex + (y + this.borderY0) * this.intensity.stride + this.borderX0;
            for (int x = 0; x < w; ++x) {
                this.intensity.data[index++] = this.evaluateMask(x, y);
            }
        }
        this.image = null;
        this.template = null;
        this.mask = null;
    }

    protected abstract float evaluate(int var1, int var2);

    protected abstract float evaluateMask(int var1, int var2);

    @Override
    public GrayF32 getIntensity() {
        return this.intensity;
    }

    @Override
    public int getBorderX0() {
        return this.borderX0;
    }

    @Override
    public int getBorderY0() {
        return this.borderY0;
    }

    @Override
    public int getBorderX1() {
        return this.borderX1;
    }

    @Override
    public int getBorderY1() {
        return this.borderY1;
    }
}

