/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.optimization;

import boofcv.abst.geo.optimization.ModelCodecSwapData;
import boofcv.alg.geo.ModelObservationResidual;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DenseMatrix64F;

public class ResidualsEpipolarMatrix
implements FunctionNtoM {
    protected ModelCodec<DenseMatrix64F> param;
    protected List<AssociatedPair> obs;
    protected ModelObservationResidual<DenseMatrix64F, AssociatedPair> residual;
    protected DenseMatrix64F F = new DenseMatrix64F(3, 3);

    public ResidualsEpipolarMatrix(ModelCodec<DenseMatrix64F> param, ModelObservationResidual<DenseMatrix64F, AssociatedPair> residual) {
        this.param = param == null ? new ModelCodecSwapData(9) : param;
        this.residual = residual;
    }

    public void setObservations(List<AssociatedPair> obs) {
        this.obs = obs;
    }

    public int getNumOfInputsN() {
        return this.param.getParamLength();
    }

    public int getNumOfOutputsM() {
        return this.obs.size();
    }

    public void process(double[] input, double[] output) {
        this.param.decode(input, (Object)this.F);
        this.residual.setModel(this.F);
        for (int i = 0; i < this.obs.size(); ++i) {
            AssociatedPair p = this.obs.get(i);
            output[i] = this.residual.computeResidual(p);
        }
    }
}

