/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetector;
import boofcv.abst.fiducial.FiducialStability;
import boofcv.abst.fiducial.calib.CalibrationDetectorChessboard;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareFiducialGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareGrid;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.RefinePnP;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.core.image.GConvertImage;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class CalibrationFiducialDetector<T extends ImageGray>
implements FiducialDetector<T> {
    CalibrationDetector detector;
    PointTransform_F64 distortToUndistorted;
    Estimate1ofPnP estimatePnP;
    RefinePnP refinePnP;
    boolean targetDetected;
    Se3_F64 initialEstimate = new Se3_F64();
    Se3_F64 targetToCamera = new Se3_F64();
    GrayF32 converted;
    ImageType<T> type;
    List<Point2D3D> points2D3D;
    List<Point2D3D> used2D3D = new ArrayList<Point2D3D>();
    double width;
    Se3_F64 referenceCameraToTarget = new Se3_F64();
    Se3_F64 targetToCameraSample = new Se3_F64();
    Se3_F64 difference = new Se3_F64();
    private Rodrigues_F64 rodrigues = new Rodrigues_F64();
    private double maxLocation;
    private double maxOrientation;

    public CalibrationFiducialDetector(ConfigChessboard config, Class<T> imageType) {
        CalibrationDetectorChessboard detector = FactoryCalibrationTarget.detectorChessboard(config);
        double sideWidth = (double)config.numCols * config.squareWidth;
        double sideHeight = (double)config.numRows * config.squareWidth;
        double width = (sideWidth + sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    public CalibrationFiducialDetector(ConfigSquareGrid config, Class<T> imageType) {
        CalibrationDetectorSquareGrid detector = FactoryCalibrationTarget.detectorSquareGrid(config);
        int squareCols = config.numCols;
        int squareRows = config.numRows;
        double sideWidth = (double)squareCols * config.squareWidth + (double)(squareCols - 1) * config.spaceWidth;
        double sideHeight = (double)squareRows * config.squareWidth + (double)(squareRows - 1) * config.spaceWidth;
        double width = (sideWidth + sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    public CalibrationFiducialDetector(ConfigSquareGridBinary config, Class<T> imageType) {
        CalibrationDetectorSquareFiducialGrid detector = FactoryCalibrationTarget.detectorBinaryGrid(config);
        int squareCols = config.numCols;
        int squareRows = config.numRows;
        double sideWidth = (double)squareCols * config.squareWidth + (double)(squareCols - 1) * config.spaceWidth;
        double sideHeight = (double)squareRows * config.squareWidth + (double)(squareRows - 1) * config.spaceWidth;
        double width = (sideWidth + sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    protected void init(CalibrationDetector detector, double width, Class<T> imageType) {
        this.detector = detector;
        this.type = ImageType.single(imageType);
        this.converted = new GrayF32(1, 1);
        this.width = width;
        List<Point2D_F64> layout = detector.getLayout();
        this.points2D3D = new ArrayList<Point2D3D>();
        for (int i = 0; i < layout.size(); ++i) {
            Point2D_F64 p2 = layout.get(i);
            Point2D3D p = new Point2D3D();
            p.location.set(p2.x, p2.y, 0.0);
            this.points2D3D.add(p);
        }
        this.estimatePnP = FactoryMultiView.computePnPwithEPnP(10, 0.2);
        this.refinePnP = FactoryMultiView.refinePnP(1.0E-8, 100);
    }

    @Override
    public void detect(T input) {
        if (input instanceof GrayF32) {
            this.converted = (GrayF32)input;
        } else {
            this.converted.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            GConvertImage.convert(input, this.converted);
        }
        if (!this.detector.process(this.converted)) {
            this.targetDetected = false;
            return;
        }
        this.targetDetected = true;
        CalibrationObservation view = this.detector.getDetectedPoints();
        if (view.size() >= 3) {
            this.used2D3D.clear();
            for (int i = 0; i < view.size(); ++i) {
                int gridIndex = view.get((int)i).index;
                Point2D3D p23 = this.points2D3D.get(gridIndex);
                Point2D_F64 pixel = view.get((int)i).pixel;
                this.distortToUndistorted.compute(pixel.x, pixel.y, p23.observation);
                this.used2D3D.add(p23);
            }
            this.targetDetected = this.estimatePose(this.targetToCamera);
        } else {
            this.targetDetected = false;
        }
    }

    private boolean estimatePose(Se3_F64 targetToCamera) {
        return this.estimatePnP.process(this.used2D3D, this.initialEstimate) && this.refinePnP.fitModel(this.used2D3D, this.initialEstimate, targetToCamera);
    }

    @Override
    public boolean computeStability(int which, double disturbance, FiducialStability results) {
        if (!this.targetDetected) {
            return false;
        }
        this.targetToCamera.invert(this.referenceCameraToTarget);
        CalibrationObservation view = this.detector.getDetectedPoints();
        Point2D_F64 workPt = new Point2D_F64();
        this.maxOrientation = 0.0;
        this.maxLocation = 0.0;
        for (int i = 0; i < view.size(); ++i) {
            int gridIndex = view.get((int)i).index;
            Point2D3D p23 = this.points2D3D.get(gridIndex);
            Point2D_F64 p = view.get((int)i).pixel;
            workPt.set(p);
            this.perturb(disturbance, workPt, p, p23);
        }
        results.location = this.maxLocation;
        results.orientation = this.maxOrientation;
        return true;
    }

    private void perturb(double disturbance, Point2D_F64 pixel, Point2D_F64 original, Point2D3D p23) {
        pixel.x = original.x + disturbance;
        this.computeDisturbance(pixel, p23);
        pixel.x = original.x - disturbance;
        this.computeDisturbance(pixel, p23);
        pixel.y = original.y;
        pixel.y = original.y + disturbance;
        this.computeDisturbance(pixel, p23);
        pixel.y = original.y - disturbance;
        this.computeDisturbance(pixel, p23);
    }

    private void computeDisturbance(Point2D_F64 pixel, Point2D3D p23) {
        this.distortToUndistorted.compute(pixel.x, pixel.y, p23.observation);
        if (this.estimatePose(this.targetToCameraSample)) {
            this.referenceCameraToTarget.concat(this.targetToCameraSample, this.difference);
            double d = this.difference.getT().norm();
            ConvertRotation3D_F64.matrixToRodrigues((DenseMatrix64F)this.difference.getR(), (Rodrigues_F64)this.rodrigues);
            double theta = Math.abs(this.rodrigues.theta);
            if (theta > this.maxOrientation) {
                this.maxOrientation = theta;
            }
            if (d > this.maxLocation) {
                this.maxLocation = d;
            }
        }
    }

    @Override
    public void setIntrinsic(IntrinsicParameters intrinsic) {
        this.distortToUndistorted = LensDistortionOps.transformPoint(intrinsic).undistort_F64(true, false);
    }

    @Override
    public int totalFound() {
        return this.targetDetected ? 1 : 0;
    }

    @Override
    public void getFiducialToCamera(int which, Se3_F64 fiducialToCamera) {
        if (which == 0) {
            fiducialToCamera.set(this.targetToCamera);
        }
    }

    @Override
    public long getId(int which) {
        return 0L;
    }

    @Override
    public double getWidth(int which) {
        return this.width;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.type;
    }

    @Override
    public boolean isSupportedID() {
        return false;
    }

    @Override
    public boolean isSupportedPose() {
        return true;
    }

    @Override
    public boolean isSizeKnown() {
        return true;
    }

    public List<Point2D_F64> getCalibrationPoints() {
        return this.detector.getLayout();
    }

    public CalibrationDetector getDetector() {
        return this.detector;
    }
}

