/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.feature.detdesc.DetectDescribeSurfPlanar;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;

public class SurfPlanar_to_DetectDescribePoint<T extends ImageGray, II extends ImageGray>
implements DetectDescribePoint<Planar<T>, BrightFeature> {
    DetectDescribeSurfPlanar<II> alg;
    T gray;
    II grayII;
    Planar<II> bandII;

    public SurfPlanar_to_DetectDescribePoint(DetectDescribeSurfPlanar<II> alg, Class<T> imageType, Class<II> integralType) {
        this.alg = alg;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.grayII = GeneralizedImageOps.createSingleBand(integralType, 1, 1);
        this.bandII = new Planar<II>(integralType, 1, 1, alg.getDescribe().getNumBands());
    }

    @Override
    public void detect(Planar<T> input) {
        ((ImageGray)this.gray).reshape(input.width, input.height);
        ((ImageGray)this.grayII).reshape(input.width, input.height);
        this.bandII.reshape(input.width, input.height);
        GConvertImage.average(input, this.gray);
        GIntegralImageOps.transform(this.gray, this.grayII);
        for (int i = 0; i < input.getNumBands(); ++i) {
            GIntegralImageOps.transform(input.getBand(i), this.bandII.getBand(i));
        }
        this.alg.detect(this.grayII, this.bandII);
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }

    @Override
    public BrightFeature getDescription(int index) {
        return this.alg.getDescription(index);
    }

    @Override
    public BrightFeature createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.alg.getNumberOfFeatures();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.alg.getLocation(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.alg.getRadius(featureIndex);
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.alg.getOrientation(featureIndex);
    }
}

