/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.inference;

import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import bayesnet.jayes.inference.AbstractInferer;
import bayesnet.jayes.sampling.BasicSampler;
import bayesnet.jayes.util.MathUtils;
import java.util.Map;

public class RejectionSampling
extends AbstractInferer {
    private static final int DEFAULT_SAMPLE_COUNT = 200;
    private int sampleCount = 200;
    private final BasicSampler sampler = new BasicSampler();

    @Override
    public void setNetwork(BayesNet bn) {
        super.setNetwork(bn);
        this.sampler.setNetwork(bn);
    }

    @Override
    protected void updateBeliefs() {
        for (int i = 0; i < this.sampleCount; ++i) {
            Map<BayesNode, String> sample = this.sampler.sample();
            boolean isConsistentWithEvidence = this.isConsistenWithEvidence(sample);
            if (!isConsistentWithEvidence) {
                --i;
                continue;
            }
            for (Map.Entry<BayesNode, String> e : sample.entrySet()) {
                BayesNode n = e.getKey();
                double[] dArray = this.beliefs[n.getId()];
                int n2 = n.getOutcomeIndex(e.getValue());
                dArray[n2] = dArray[n2] + 1.0;
            }
        }
        this.normalizeBeliefs();
    }

    private void normalizeBeliefs() {
        for (int i = 0; i < this.beliefs.length; ++i) {
            this.beliefs[i] = MathUtils.normalize(this.beliefs[i]);
        }
    }

    private boolean isConsistenWithEvidence(Map<BayesNode, String> sample) {
        for (Map.Entry e : this.evidence.entrySet()) {
            boolean sampleMatchesEvidence = ((String)e.getValue()).equals(sample.get(e.getKey()));
            if (sampleMatchesEvidence) continue;
            return false;
        }
        return true;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public void seed(long seed) {
        this.sampler.seed(seed);
    }
}

