/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.factor;

import bayesnet.internal.jayes.util.ArrayUtils;
import bayesnet.jayes.BayesNet;
import bayesnet.jayes.factor.AbstractFactor;
import bayesnet.jayes.factor.DenseFactor;
import bayesnet.jayes.factor.SparseFactor;
import bayesnet.jayes.factor.arraywrapper.DoubleArrayWrapper;
import bayesnet.jayes.factor.arraywrapper.FloatArrayWrapper;
import bayesnet.jayes.factor.arraywrapper.IArrayWrapper;
import bayesnet.jayes.util.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class FactorFactory {
    private BayesNet net;
    private boolean useLogScale = false;
    private IArrayWrapper prototype = new DoubleArrayWrapper(0.0);

    public void setFloatingPointType(Class<?> contentType) {
        if (contentType == Double.TYPE || contentType == Double.class) {
            this.prototype = new DoubleArrayWrapper(0.0);
        } else if (contentType == Float.TYPE || contentType == Float.class) {
            this.prototype = new FloatArrayWrapper(0.0f);
        } else {
            throw new IllegalArgumentException("wrong type, expected double, Double, float or Float, but got: " + contentType);
        }
    }

    public void setReferenceNetwork(BayesNet net) {
        this.net = net;
    }

    public BayesNet getReferenceNetwork() {
        return this.net;
    }

    public void setUseLogScale(boolean useLogScale) {
        this.useLogScale = useLogScale;
    }

    public AbstractFactor create(List<Integer> vars, List<AbstractFactor> multiplicationPartners) {
        int[] dimensions = this.getDimensionSizes(vars);
        AbstractFactor[] partners = multiplicationPartners.toArray(new AbstractFactor[0]);
        if (SparseFactor.isSuitable(MathUtils.product(dimensions), partners)) {
            SparseFactor f = new SparseFactor();
            this.initializeFactor(vars, dimensions, f);
            f.sparsify(partners);
            return f;
        }
        DenseFactor f2 = new DenseFactor();
        this.initializeFactor(vars, dimensions, f2);
        return f2;
    }

    private void initializeFactor(List<Integer> vars, int[] dimensions, AbstractFactor f) {
        f.setValues(this.prototype.clone());
        f.setDimensions(dimensions);
        f.setDimensionIDs(ArrayUtils.toIntArray(vars));
        if (this.useLogScale) {
            f.setLogScale(true);
        }
    }

    private int[] getDimensionSizes(List<Integer> vars) {
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        for (Integer dim : vars) {
            dimensions.add(this.net.getNode(dim).getOutcomeCount());
        }
        return ArrayUtils.toIntArray(dimensions);
    }

    protected boolean getUseLogScale(AbstractFactor f) {
        return this.useLogScale;
    }

    public static FactorFactory defaultFactory() {
        return new FactorFactory();
    }
}

