/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.factor;

import bayesnet.jayes.factor.AbstractFactor;
import bayesnet.jayes.util.MathUtils;

public class Cut
implements Cloneable {
    private final AbstractFactor factor;
    private int start;
    private int stepSize;
    private int length;
    private int subtreeStepsize;
    private int rootDimension;
    private int leafDimension;
    private Cut subCut;

    public Cut(AbstractFactor factor) {
        this.factor = factor;
    }

    public void initialize() {
        this.length = MathUtils.product(this.factor.getDimensions());
        this.start = 0;
        this.stepSize = 1;
        this.rootDimension = 0;
        this.subtreeStepsize = this.length > 1 ? this.length / this.factor.getDimensions()[0] : 0;
        this.leafDimension = this.factor.getDimensions().length - 1;
        this.subCut = null;
        this.leafCut();
        this.rootCut();
        this.createSubcut();
    }

    public Cut clone() {
        try {
            return (Cut)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void rootCut() {
        while (this.rootDimension < this.leafDimension && this.factor.selections[this.rootDimension] != -1) {
            this.descendSelectedDimension();
        }
        while (this.rootDimension < this.leafDimension && this.factor.selections[this.rootDimension + 1] == -1) {
            this.descendUnselectedDimension();
        }
    }

    private void descendSelectedDimension() {
        this.length /= this.factor.dimensions[this.rootDimension];
        this.start += this.subtreeStepsize * this.factor.selections[this.rootDimension];
        this.descendUnselectedDimension();
    }

    private void descendUnselectedDimension() {
        ++this.rootDimension;
        this.subtreeStepsize /= this.factor.dimensions[this.rootDimension];
    }

    private void leafCut() {
        while (this.leafDimension >= 0 && this.factor.selections[this.leafDimension] != -1) {
            this.ascendSelectedDimension();
        }
    }

    private void ascendSelectedDimension() {
        this.start += this.factor.selections[this.leafDimension] * this.stepSize;
        this.stepSize *= this.factor.dimensions[this.leafDimension];
        --this.leafDimension;
    }

    private void createSubcut() {
        if (this.needsSplit()) {
            this.subCut = null;
            this.subCut = this.clone();
            this.subCut.descendUnselectedDimension();
            this.subCut.length = this.subtreeStepsize;
            this.subCut.rootCut();
            this.subCut.createSubcut();
        }
    }

    private boolean needsSplit() {
        if (this.length < this.subtreeStepsize) {
            return false;
        }
        for (int i = this.rootDimension; i < this.leafDimension; ++i) {
            if (this.factor.selections[i] == -1) continue;
            return true;
        }
        return false;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.start + this.length;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public int getLength() {
        return this.length;
    }

    public int getSubtreeStepsize() {
        return this.subtreeStepsize;
    }

    public Cut getSubCut() {
        return this.subCut;
    }
}

