/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.internal.jayes.util;

import bayesnet.jayes.factor.AbstractFactor;
import bayesnet.jayes.util.MathUtils;
import java.util.HashMap;
import java.util.Map;

public final class AddressCalc {
    private AddressCalc() {
    }

    public static void incrementMultiDimensionalCounter(int[] counter, int[] dimensions) {
        int dimension;
        int n = dimension = counter.length - 1;
        counter[n] = counter[n] + 1;
        while (counter[dimension] == dimensions[dimension]) {
            counter[dimension] = 0;
            int n2 = --dimension;
            counter[n2] = counter[n2] + 1;
        }
    }

    public static int[] computeLinearMap(AbstractFactor factor, int ... dimensionIDs) {
        return AddressCalc.computeLinearMap(AddressCalc.computeIdToDimensionIndexMap(factor), factor.getDimensions(), dimensionIDs);
    }

    private static int[] computeLinearMap(Map<Integer, Integer> foreignIdToIndex, int[] foreignDimensions, int[] dimensionIds) {
        int[] kernel = new int[dimensionIds.length];
        for (int i = 0; i < kernel.length; ++i) {
            int dimensionId = dimensionIds[i];
            if (!foreignIdToIndex.containsKey(dimensionId)) continue;
            kernel[i] = MathUtils.productOfRange(foreignDimensions, foreignIdToIndex.get(dimensionId) + 1, foreignDimensions.length);
        }
        return kernel;
    }

    private static Map<Integer, Integer> computeIdToDimensionIndexMap(AbstractFactor factor) {
        HashMap<Integer, Integer> foreignIds = new HashMap<Integer, Integer>();
        for (int i = 0; i < factor.getDimensionIDs().length; ++i) {
            foreignIds.put(factor.getDimensionIDs()[i], i);
        }
        return foreignIds;
    }
}

