/*
 * Decompiled with CFR 0.152.
 */
package bayesnet;

import bayesnet.BayesianNetwork;
import bayesnet.Node;
import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import bayesnet.jayes.io.IBayesNetWriter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class CommonsWriter
implements IBayesNetWriter {
    private OutputStream out;

    public CommonsWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(BayesNet bayesNet) throws IOException {
        try {
            BayesianNetwork.write(this.toBayesianNetwork(bayesNet), this.out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private BayesianNetwork toBayesianNetwork(BayesNet bayesNet) {
        Node n;
        BayesianNetwork network = new BayesianNetwork();
        for (BayesNode node : bayesNet.getNodes()) {
            n = new Node(node.getName());
            n.setStates(node.getOutcomes().toArray(new String[node.getOutcomeCount()]));
            network.addNode(n);
        }
        for (BayesNode node : bayesNet.getNodes()) {
            n = network.getNode(node.getName());
            ArrayList parents = Lists.newArrayList();
            for (BayesNode parent : node.getParents()) {
                parents.add(network.getNode(parent.getName()));
            }
            n.setParents(parents.toArray(new Node[parents.size()]));
            n.setProbabilities(node.getProbabilities());
        }
        return network;
    }
}

