/*
 * Decompiled with CFR 0.152.
 */
package jplot3dp.MathParser;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import jplot3dp.MathParser.MathParserConstants;
import jplot3dp.MathParser.MathParserTokenManager;
import jplot3dp.MathParser.ParseException;
import jplot3dp.MathParser.SimpleCharStream;
import jplot3dp.MathParser.Token;

public class MathParser
implements MathParserConstants {
    private HashMap userVars = new HashMap();
    public MathParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public MathParser() {
        this(new StringReader(""));
        this.resetVariables();
    }

    public void resetVariables() {
        this.userVars.clear();
        this.setVariable("Pi", Math.PI);
        this.setVariable("E", Math.E);
    }

    public void setVariable(String varName, double varValue) {
        this.userVars.put(varName, new Double(varValue));
    }

    public double getVariable(String varName) {
        if (this.userVars.containsKey(varName)) {
            return (Double)this.userVars.get(varName);
        }
        return 0.0;
    }

    public double parseExpression(String s) throws ParseException {
        this.ReInit(new StringReader(s + ";"));
        return this.Go();
    }

    public final double GetNextTerm() throws ParseException, NumberFormatException {
        Object fn = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                double d = this.ParseLevel3();
                return -d;
            }
            case 57: {
                Token t = this.jj_consume_token(57);
                return Double.parseDouble(t.image);
            }
            case 58: {
                Token t = this.jj_consume_token(58);
                return this.getVariable(t.image);
            }
            case 19: {
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return d;
            }
            case 22: {
                this.jj_consume_token(22);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(60);
                double d2 = this.Expression();
                this.jj_consume_token(20);
                return Math.atan2(d, d2);
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.sin(d);
            }
            case 24: {
                this.jj_consume_token(24);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.cos(d);
            }
            case 25: {
                this.jj_consume_token(25);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.tan(d);
            }
            case 26: {
                this.jj_consume_token(26);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return 1.0 / Math.sin(d);
            }
            case 27: {
                this.jj_consume_token(27);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return 1.0 / Math.cos(d);
            }
            case 28: {
                this.jj_consume_token(28);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return 1.0 / Math.tan(d);
            }
            case 29: {
                this.jj_consume_token(29);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.asin(d);
            }
            case 30: {
                this.jj_consume_token(30);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.acos(d);
            }
            case 31: {
                this.jj_consume_token(31);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.atan(d);
            }
            case 32: {
                this.jj_consume_token(32);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.asin(1.0 / d);
            }
            case 33: {
                this.jj_consume_token(33);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.acos(1.0 / d);
            }
            case 34: {
                this.jj_consume_token(34);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.atan(1.0 / d);
            }
            case 35: {
                this.jj_consume_token(35);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return (Math.exp(d) - Math.exp(-d)) / 2.0;
            }
            case 36: {
                this.jj_consume_token(36);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return (Math.exp(d) + Math.exp(-d)) / 2.0;
            }
            case 37: {
                this.jj_consume_token(37);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return (Math.exp(d) - Math.exp(-d)) / (Math.exp(d) + Math.exp(-d));
            }
            case 38: {
                this.jj_consume_token(38);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return 2.0 / (Math.exp(d) - Math.exp(-d));
            }
            case 39: {
                this.jj_consume_token(39);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return 2.0 / (Math.exp(d) + Math.exp(-d));
            }
            case 40: {
                this.jj_consume_token(40);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return (Math.exp(d) + Math.exp(-d)) / (Math.exp(d) - Math.exp(-d));
            }
            case 41: {
                this.jj_consume_token(41);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.log(d + Math.sqrt(d * d + 1.0));
            }
            case 42: {
                this.jj_consume_token(42);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.log(d + Math.sqrt(d * d - 1.0));
            }
            case 43: {
                this.jj_consume_token(43);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
            }
            case 44: {
                this.jj_consume_token(44);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.log(Math.sqrt(1.0 / d / d - 1.0) + 1.0 / d);
            }
            case 45: {
                this.jj_consume_token(45);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.log(Math.sqrt(1.0 / d / d - 1.0) + 1.0 / d);
            }
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.log((d + 1.0) / (d - 1.0)) / 2.0;
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.sqrt(d);
            }
            case 48: {
                this.jj_consume_token(48);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.exp(d);
            }
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.log(d);
            }
            case 50: {
                this.jj_consume_token(50);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.log(d) / Math.log(10.0);
            }
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.tan(d) / Math.log(2.0);
            }
            case 52: {
                this.jj_consume_token(52);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.abs(d);
            }
            case 53: {
                this.jj_consume_token(53);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.floor(d);
            }
            case 54: {
                this.jj_consume_token(54);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                if (d > 0.0) {
                    return 1.0;
                }
                if (d < 0.0) {
                    return -1.0;
                }
                return 0.0;
            }
            case 55: {
                this.jj_consume_token(55);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return Math.ceil(d);
            }
            case 56: {
                this.jj_consume_token(56);
                this.jj_consume_token(19);
                double d = this.Expression();
                this.jj_consume_token(20);
                return d - Math.floor(d);
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double Go() throws ParseException {
        double x;
        block20: {
            x = 0.0;
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(3);
            }
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 19: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block20;
                    }
                }
                if (this.jj_2_1(2)) {
                    x = this.Expression();
                    block17: while (true) {
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 3: {
                                continue block17;
                            }
                        }
                        break;
                    }
                    this.jj_la1[3] = this.jj_gen;
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        Token t = this.jj_consume_token(58);
                        this.jj_consume_token(21);
                        x = this.Expression();
                        this.setVariable(t.image, x);
                        block18: while (true) {
                            this.jj_consume_token(3);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 3: {
                                    continue block18;
                                }
                            }
                            break;
                        }
                        this.jj_la1[4] = this.jj_gen;
                        continue block16;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final double Expression() throws ParseException, NumberFormatException {
        double value;
        block12: {
            value = this.ParseLevel1();
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        double x = this.ParseLevel1();
                        value = value == x ? 1.0 : 0.0;
                        continue block11;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        double x = this.ParseLevel1();
                        value = value != x ? 1.0 : 0.0;
                        continue block11;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        double x = this.ParseLevel1();
                        value = value < x ? 1.0 : 0.0;
                        continue block11;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        double x = this.ParseLevel1();
                        value = value <= x ? 1.0 : 0.0;
                        continue block11;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        double x = this.ParseLevel1();
                        value = value > x ? 1.0 : 0.0;
                        continue block11;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        double x = this.ParseLevel1();
                        value = value >= x ? 1.0 : 0.0;
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[7] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return value;
    }

    public final double ParseLevel1() throws ParseException, NumberFormatException {
        double value;
        block8: {
            value = this.ParseLevel2();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        double x = this.ParseLevel2();
                        value += x;
                        continue block7;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        double x = this.ParseLevel2();
                        value -= x;
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return value;
    }

    public final double ParseLevel2() throws ParseException, NumberFormatException {
        double value = this.ParseLevel3();
        block7: while (this.jj_2_2(1)) {
            double x;
            if (this.jj_2_3(1)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        x = this.ParseLevel3();
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        if (this.getToken((int)1).kind != 14) {
                            x = this.ParseLevel3();
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                value *= x;
                continue;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    this.jj_consume_token(16);
                    x = this.ParseLevel3();
                    value /= x;
                    continue block7;
                }
                case 17: {
                    this.jj_consume_token(17);
                    x = this.ParseLevel3();
                    value %= x;
                    continue block7;
                }
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return value;
    }

    public final double ParseLevel3() throws ParseException, NumberFormatException {
        double value = this.GetNextTerm();
        while (this.jj_2_4(2)) {
            this.jj_consume_token(18);
            double x = this.ParseLevel3();
            value = Math.pow(value, x);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private final boolean jj_3R_14() {
        Token xsp;
        if (this.jj_3R_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_11() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_10() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_10()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_11()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind != 14;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_13()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_63() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_61() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_60() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_59() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_58() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_57() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_18() {
        Token xsp;
        if (this.jj_3R_14()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_2());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_53() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_66() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_65() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_66()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_45() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_39() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_15() {
        Token xsp;
        if (this.jj_3R_18()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_19());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_25() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_28() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_24() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_27() {
        return this.jj_scan_token(57);
    }

    private final boolean jj_3R_23() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_27()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_28()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_29()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_30()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_31()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_32()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_33()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_34()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_35()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_36()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_37()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_38()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_39()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_40()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_41()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_42()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_43()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_44()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_45()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_46()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_47()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_48()) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_3R_49()) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_3R_50()) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_3R_51()) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_3R_52()) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_3R_53()) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_3R_54()) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_3R_55()) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_3R_56()) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_3R_57()) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_3R_58()) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_3R_59()) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_3R_60()) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_3R_61()) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_3R_62()) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_3R_63()) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_3R_64()) {
                                                                                                                                                                    return true;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private final boolean jj_3R_22() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_21() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_20() {
        return this.jj_scan_token(7);
    }

    private final boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_22()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_23()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_24()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_25()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_9() {
        Token xsp;
        if (this.jj_3R_15()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_16());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private final boolean jj_3_1() {
        Token xsp;
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(3));
        this.jj_scanpos = xsp;
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{-3653632, 8, -3653632, 8, 8, 0, 8064, 8064, 24576, 24576, 32768, 196608};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0x7FFFFFF, 0, 0x7FFFFFF, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0};
    }

    public MathParser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MathParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MathParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MathParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MathParser(MathParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(MathParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[61];
        for (i = 0; i < 61; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 12; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 61; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        MathParser.jj_la1_0();
        MathParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

