/*
 * Decompiled with CFR 0.152.
 */
package jplot3d.draw;

import java.awt.Rectangle;
import java.util.Arrays;
import jplot3d.JPoint;
import jplot3d.JSurface;
import jplot3d.draw.DrawPlain2;

public class DrawP3D {
    public static final void run(JSurface sf) {
        float z1;
        float y1;
        float x1;
        Object jpp;
        int ii;
        float zx;
        float zi;
        if (sf == null) {
            return;
        }
        Object[] jpoint = sf.model.getJPoints();
        if (jpoint == null) {
            return;
        }
        boolean printing = sf.printing;
        float xfactor = sf.model.getPlotter().getFactorX();
        float yfactor = sf.model.getPlotter().getFactorY();
        float zfactor = sf.model.getPlotter().getFactorZ();
        Rectangle comp = sf.getBounds();
        int h = (int)comp.getHeight();
        int w = (int)comp.getWidth();
        float xi = sf.model.getXMin();
        float xx = sf.model.getXMax();
        float yi = sf.model.getYMin();
        float yx = sf.model.getYMax();
        try {
            zi = sf.model.getZMin();
            zx = sf.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            return;
        }
        Thread.yield();
        sf.zmin = zi;
        sf.zmax = zx;
        sf.projector.setZRange(sf.zmin, sf.zmax);
        zfactor = 20.0f / (zx - zi);
        xfactor = 20.0f / (xx - xi);
        yfactor = 20.0f / (yx - yi);
        if (!printing) {
            sf.graphics.setColor(sf.getSurfaceColor().getBackgroundColor());
            sf.graphics.fillRect(0, 0, w, h);
        }
        sf.drawBoxGridsTicksLabels(sf.graphics, false);
        if (sf.projector == null) {
            return;
        }
        int[] x = new int[5];
        int[] y = new int[5];
        if (sf.getProjector() == null) {
            return;
        }
        float distance = sf.getProjector().getDistance() * sf.getProjector().getCosElevationAngle();
        float oX = distance * sf.getProjector().getSinRotationAngle();
        float oY = distance * sf.getProjector().getCosRotationAngle();
        float oZ = sf.getProjector().getDistance() * sf.getProjector().getSinElevationAngle();
        for (ii = 0; ii < jpoint.length; ++ii) {
            if (jpoint[ii] == null || (jpp = jpoint[ii]) == null) continue;
            x1 = ((float)((JPoint)jpp).getX() - xi) * xfactor - 10.0f;
            y1 = ((float)((JPoint)jpp).getY() - yi) * yfactor - 10.0f;
            z1 = ((float)((JPoint)jpp).getZ() - zi) * zfactor - 10.0f;
            float dxx = (oX - x1) * (oX - x1);
            float dyy = (oY - y1) * (oY - y1);
            float dzz = (oZ - z1) * (oZ - z1);
            ((JPoint)jpoint[ii]).setD(dxx + dyy + dzz);
        }
        Arrays.sort(jpoint);
        for (ii = jpoint.length - 1; ii >= 0; --ii) {
            jpp = jpoint[ii];
            x1 = ((float)((JPoint)jpp).getX() - xi) * xfactor - 10.0f;
            y1 = ((float)((JPoint)jpp).getY() - yi) * yfactor - 10.0f;
            z1 = ((float)((JPoint)jpp).getZ() - zi) * zfactor - 10.0f;
            float dx = (float)((JPoint)jpp).getDX() * xfactor;
            float dy = (float)((JPoint)jpp).getDY() * yfactor;
            float dz = (float)((JPoint)jpp).getDZ() * zfactor;
            int sis = (int)(0.15 * (double)((JPoint)jpp).getSymbolSize() * (double)sf.projector.get2DScaling());
            DrawPlain2.run(5, x1, y1, z1, dx, dy, dz, ((JPoint)jpp).getSymbolColor(), sis, sf);
            DrawPlain2.run(1, x1, y1, z1, dx, dy, dz, ((JPoint)jpp).getSymbolColor(), sis, sf);
            DrawPlain2.run(2, x1, y1, z1, dx, dy, dz, ((JPoint)jpp).getSymbolColor(), sis, sf);
            DrawPlain2.run(3, x1, y1, z1, dx, dy, dz, ((JPoint)jpp).getSymbolColor(), sis, sf);
            DrawPlain2.run(4, x1, y1, z1, dx, dy, dz, ((JPoint)jpp).getSymbolColor(), sis, sf);
            DrawPlain2.run(0, x1, y1, z1, dx, dy, dz, ((JPoint)jpp).getSymbolColor(), sis, sf);
        }
        if (sf.isBoxed) {
            sf.drawBoundingBox();
        }
    }
}

