/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.Color;
import java.io.PrintStream;
import java.io.Serializable;
import jplot.GraphSettings;
import jplot.XMLRead;
import jplot.XMLWrite;

public class LinePars
implements Serializable {
    private static final long serialVersionUID = 1L;
    String name;
    String nameX;
    String nameY;
    String nameZ;
    public static final int LINES = 0;
    public static final int HISTO = 1;
    public static final int CONTOUR = 2;
    public static final int H1D = 101;
    public static final int F1D = 102;
    public static final int P1D = 103;
    public static final int H2D = 201;
    public static final int H3D = 301;
    public static final int STICKS = 2;
    static final int NO_SYMBOL = 13;
    protected Color color;
    protected Color startColor;
    protected Color endColor;
    protected Color fillColor;
    protected int redInc;
    protected int greenInc;
    protected int blueInc;
    protected boolean slideColor;
    protected boolean fillArea;
    protected float fillColorTransparency;
    protected double widthBin;
    protected float penWidthErrSys;
    protected float penWidthErr;
    protected float errTicSize;
    protected int type;
    protected boolean fillBars;
    protected int symbol;
    protected int every;
    protected float symbolSize;
    protected boolean useSymbol;
    protected float multiplier;
    protected float additioner;
    protected boolean errorsShowY;
    protected boolean errorsShowX;
    protected boolean errorsShowSysY;
    protected boolean errorsShowSysX;
    protected Color errorsColorY;
    protected Color errorsColorX;
    protected Color errorsColorSysY;
    protected Color errorsColorSysX;
    protected boolean errorsFill;
    protected boolean errorsFillSys;
    protected Color errorsFillColor;
    protected Color errorsFillColorSys;
    protected float errorsFillColorTransp;
    protected float errorsFillColorTranspSys;
    protected int colorIndex;
    protected int dashIndex;
    protected float dashLength;
    protected float penWidth;
    protected boolean plotLine;
    protected int style;
    protected boolean showLegend;
    protected boolean dataModified;

    public LinePars(String s) {
        this.colorIndex = 0;
        this.dashIndex = 0;
        this.fillBars = false;
        this.color = GraphSettings.color[0];
        this.type = 101;
        this.fillColor = new Color(255, 255, 205);
        this.fillColorTransparency = 0.4f;
        this.fillArea = false;
        this.dashLength = 0.0f;
        this.penWidth = 1.0f;
        this.errTicSize = this.penWidth * 2.0f;
        this.penWidthErrSys = this.penWidth;
        this.penWidthErr = this.penWidth;
        this.symbol = 13;
        this.symbolSize = 5.0f;
        this.useSymbol = false;
        this.plotLine = true;
        this.every = 1;
        this.style = 0;
        this.showLegend = true;
        this.widthBin = 0.0;
        this.name = s;
        this.nameX = "X";
        this.nameY = "Y";
        this.nameZ = "Z";
        this.errorsShowY = true;
        this.errorsShowX = false;
        this.errorsShowSysY = false;
        this.errorsShowSysX = false;
        this.errorsColorY = Color.black;
        this.errorsColorX = Color.black;
        this.errorsColorSysY = Color.black;
        this.errorsColorSysX = Color.black;
        this.multiplier = 1.0f;
        this.additioner = 0.0f;
        this.slideColor = false;
        this.startColor = this.color;
        this.endColor = this.color;
        this.blueInc = 0;
        this.greenInc = 0;
        this.redInc = 0;
        this.dataModified = false;
        this.errorsFill = false;
        this.errorsFillSys = false;
        this.errorsFillColor = Color.green;
        this.errorsFillColorSys = Color.yellow;
        this.errorsFillColorTransp = 0.5f;
        this.errorsFillColorTranspSys = 0.5f;
    }

    public LinePars(String s, int colorIndex) {
        this(s);
        this.colorIndex = colorIndex;
        this.color = GraphSettings.color[colorIndex];
    }

    public LinePars(Color c, float dl, float pw, int s, float ss) {
        this("");
        this.color = c;
        this.colorIndex = -1;
        this.dashLength = dl;
        this.penWidth = pw;
        this.penWidthErr = pw;
        this.penWidthErrSys = pw;
        this.symbol = s;
        this.symbolSize = ss;
        this.style = 0;
        this.type = 101;
    }

    public LinePars() {
        this("");
    }

    public LinePars(LinePars lp) {
        this.copy(lp);
    }

    public LinePars(String s, Color c) {
        this(s);
        this.color = c;
    }

    public int getPointFrequency() {
        return this.every;
    }

    public int getGraphStyle() {
        return this.style;
    }

    public void setGraphStyle(int s) {
        this.style = s;
    }

    public void copy(LinePars lp) {
        this.color = lp.color;
        this.colorIndex = lp.colorIndex;
        this.fillColor = lp.fillColor;
        this.fillArea = lp.fillArea;
        this.fillColorTransparency = lp.fillColorTransparency;
        this.dashIndex = lp.dashIndex;
        this.dashLength = lp.dashLength;
        this.type = lp.type;
        this.penWidth = lp.penWidth;
        this.penWidthErrSys = lp.penWidthErrSys;
        this.errTicSize = lp.errTicSize;
        this.penWidthErr = lp.penWidthErr;
        this.symbol = lp.symbol;
        this.symbolSize = lp.symbolSize;
        this.useSymbol = lp.useSymbol;
        this.plotLine = lp.plotLine;
        this.style = lp.style;
        this.every = lp.every;
        this.name = lp.name;
        this.nameX = lp.nameX;
        this.nameY = lp.nameY;
        this.nameZ = lp.nameZ;
        this.errorsShowY = lp.errorsShowY;
        this.errorsShowX = lp.errorsShowX;
        this.errorsShowSysY = lp.errorsShowSysY;
        this.errorsShowSysX = lp.errorsShowSysX;
        this.errorsColorY = lp.errorsColorY;
        this.errorsColorX = lp.errorsColorX;
        this.errorsColorSysY = lp.errorsColorSysY;
        this.errorsColorSysX = lp.errorsColorSysX;
        this.showLegend = lp.showLegend;
        this.multiplier = lp.multiplier;
        this.additioner = lp.additioner;
        this.redInc = lp.redInc;
        this.greenInc = lp.greenInc;
        this.blueInc = lp.blueInc;
        this.slideColor = lp.slideColor;
        this.startColor = lp.startColor;
        this.endColor = lp.endColor;
        this.dataModified = lp.dataModified;
        this.errorsFill = lp.errorsFill;
        this.errorsFillSys = lp.errorsFillSys;
        this.errorsFillColor = lp.errorsFillColor;
        this.errorsFillColorSys = lp.errorsFillColorSys;
        this.errorsFillColorTransp = lp.errorsFillColorTransp;
        this.errorsFillColorTranspSys = lp.errorsFillColorTranspSys;
        this.fillBars = lp.fillBars;
    }

    public void print() {
        PrintStream out = System.out;
        this.print(out);
    }

    public void print(PrintStream out) {
        out.println(this.getAttributes());
    }

    public String getAttributes() {
        String tmp = "\n Drawing attributes";
        tmp = tmp + "\n- type         :" + this.type;
        tmp = tmp + "\n- style        :" + this.style;
        tmp = tmp + "\n- color        :" + this.color;
        tmp = tmp + "\n- fillColor    :" + this.fillColor;
        tmp = tmp + "\n- errors on X  :" + this.errorsShowX;
        tmp = tmp + "\n- errors on Y  :" + this.errorsShowY;
        tmp = tmp + "\n- error color X  :" + this.errorsColorX;
        tmp = tmp + "\n- show errors Y  :" + this.errorsColorY;
        tmp = tmp + "\n---- Line attributes ---";
        tmp = tmp + "\n- show      :" + this.plotLine;
        tmp = tmp + "\n- dash      :" + this.dashIndex;
        tmp = tmp + "\n- pen width :" + this.penWidth;
        tmp = tmp + "\n---- Point attributes-----";
        tmp = tmp + "\n-  show  :" + String.valueOf(this.useSymbol);
        tmp = tmp + "\n-  symbol:" + String.valueOf(this.symbol);
        tmp = tmp + "\n-  size  :" + String.valueOf(this.symbolSize);
        tmp = tmp + "\n-  every :" + String.valueOf(this.every);
        tmp = tmp + "\n---- Legend attributes-----";
        tmp = tmp + "\n- showLegend  :" + this.showLegend;
        tmp = tmp + "\n- text        :" + this.name;
        return tmp;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void setNameX(String s) {
        this.nameX = s;
    }

    public String getNameX() {
        return this.nameX;
    }

    public double getWidthBin() {
        return this.widthBin;
    }

    public void setWidthBin(double a) {
        this.widthBin = a;
    }

    public void setShowBars(boolean a) {
        this.fillBars = a;
    }

    public boolean isBarShown() {
        return this.fillBars;
    }

    public void setNameY(String s) {
        this.nameY = s;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getNameY() {
        return this.nameY;
    }

    public void setNameZ(String s) {
        this.nameZ = s;
    }

    public String getNameZ() {
        return this.nameZ;
    }

    public boolean drawLegend() {
        return this.showLegend;
    }

    public void setDrawLegend(boolean b) {
        this.showLegend = b;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setSlideColor(Color start, Color end) {
        this.color = start;
        this.startColor = start;
        this.endColor = end;
        this.redInc = end.getRed() - start.getRed();
        this.greenInc = end.getGreen() - start.getGreen();
        this.blueInc = end.getBlue() - start.getBlue();
        this.slideColor = true;
    }

    public void setSlideColor(boolean b) {
        this.slideColor = b;
    }

    public boolean slideColor() {
        return this.slideColor;
    }

    public void nextColor(int step) {
        this.color = new Color(this.color.getRed() + this.redInc / step, this.color.getGreen() + this.greenInc / step, this.color.getBlue() + this.blueInc / step);
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColorTransparency(float a) {
        this.fillColorTransparency = a;
    }

    public void setErrorFillColorTransp(float a) {
        this.errorsFillColorTransp = a;
    }

    public float getErrorFillColorTransp() {
        return this.errorsFillColorTransp;
    }

    public void setErrorFillColorTranspSys(float a) {
        this.errorsFillColorTranspSys = a;
    }

    public float getErrorFillColorTranspSys() {
        return this.errorsFillColorTranspSys;
    }

    public float getFillColorTransparency() {
        return this.fillColorTransparency;
    }

    public boolean fill() {
        return this.fillArea;
    }

    public void fill(boolean b) {
        this.fillArea = b;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public float getDashLength() {
        return this.dashLength;
    }

    public int getDashIndex() {
        return this.dashIndex;
    }

    public float getPenWidth() {
        return this.penWidth;
    }

    public float getPenWidthErr() {
        return this.penWidthErr;
    }

    public float getErrTicSize() {
        return this.errTicSize / this.penWidthErr;
    }

    public void setErrTicSize(float tic) {
        this.errTicSize = tic * this.penWidthErr;
    }

    public float getPenWidthErrSys() {
        return this.penWidthErrSys;
    }

    public void setPenWidthErr(float a) {
        this.penWidthErr = a;
    }

    public void setPenWidthErrSys(float a) {
        this.penWidthErrSys = a;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public void setMultiplier(float m) {
        this.multiplier = m;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setAdditioner(float m) {
        this.additioner = m;
    }

    public float getAdditioner() {
        return this.additioner;
    }

    public boolean drawSymbol() {
        return this.useSymbol;
    }

    public boolean drawLine() {
        return this.plotLine;
    }

    public float getSymbolSize() {
        return this.symbolSize;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setColor(int i) {
        this.color = GraphSettings.color[i];
        this.colorIndex = i;
    }

    public void setDashLength(float dl) {
        if (dl < 0.0f) {
            this.dashLength = 0.0f;
            this.plotLine = false;
        } else {
            this.dashLength = dl;
            this.plotLine = true;
        }
    }

    public void setDashLength(float dl, int index) {
        this.setDashLength(dl);
        this.dashIndex = index;
    }

    public void setPenWidth(float pw) {
        this.penWidth = pw;
    }

    public void setSymbol(int s) {
        this.symbol = s;
        this.useSymbol = s != 13;
    }

    public void setDrawSymbol(boolean b) {
        this.useSymbol = b;
    }

    public boolean isDrawSymbol() {
        return this.useSymbol;
    }

    public void setDrawLine(boolean b) {
        this.plotLine = b;
    }

    public boolean isDrawLine() {
        return this.plotLine;
    }

    public void setSymbolSize(float ss) {
        this.symbolSize = ss;
    }

    public void errorsY(boolean s) {
        this.errorsShowY = s;
    }

    public void errorsX(boolean s) {
        this.errorsShowX = s;
    }

    public void errorsSysY(boolean s) {
        this.errorsShowSysY = s;
    }

    public void errorsSysX(boolean s) {
        this.errorsShowSysX = s;
    }

    public void errorsFill(boolean s) {
        this.errorsFill = s;
    }

    public boolean getErrorsFill() {
        return this.errorsFill;
    }

    public void errorsFillSys(boolean s) {
        this.errorsFillSys = s;
    }

    public boolean getErrorsFillSys() {
        return this.errorsFillSys;
    }

    public void setColorErrorsY(Color col) {
        this.errorsColorY = col;
    }

    public void setColorErrorsX(Color col) {
        this.errorsColorX = col;
    }

    public void setColorErrorsSysY(Color col) {
        this.errorsColorSysY = col;
    }

    public void setColorErrorsSysX(Color col) {
        this.errorsColorSysX = col;
    }

    public void setColorErrorsFill(Color col) {
        this.errorsFillColor = col;
    }

    public Color getColorErrorsFill() {
        return this.errorsFillColor;
    }

    public void setColorErrorsFillSys(Color col) {
        this.errorsFillColorSys = col;
    }

    public Color getColorErrorsFillSys() {
        return this.errorsFillColorSys;
    }

    public boolean getErrorsY() {
        return this.errorsShowY;
    }

    public boolean getErrorsX() {
        return this.errorsShowX;
    }

    public boolean getErrorsSysY() {
        return this.errorsShowSysY;
    }

    public boolean getErrorsSysX() {
        return this.errorsShowSysX;
    }

    public Color getColorErrorsY() {
        return this.errorsColorY;
    }

    public Color getColorErrorsX() {
        return this.errorsColorX;
    }

    public Color getColorErrorsSysY() {
        return this.errorsColorSysY;
    }

    public Color getColorErrorsSysX() {
        return this.errorsColorSysX;
    }

    public void setPointFrequency(int k) {
        this.every = k;
    }

    public void getSettings(XMLWrite xw) {
        xw.setData("style", String.valueOf(this.style));
        xw.setData("type", String.valueOf(this.type));
        xw.set("color", this.color);
        xw.set("fillAreaColor", this.fillColor);
        xw.add("fill", String.valueOf(this.fillArea));
        xw.add("isbarshown", String.valueOf(this.fillBars));
        xw.add("transp", String.valueOf(this.fillColorTransparency));
        xw.set("fillArea");
        xw.add("show", String.valueOf(this.plotLine));
        xw.add("dash", String.valueOf(this.dashIndex));
        xw.add("width", String.valueOf(this.penWidth));
        xw.set("line");
        xw.set("errXcolor", this.errorsColorX);
        xw.add("show", String.valueOf(this.errorsShowX));
        xw.add("penwidth", String.valueOf(this.penWidthErr));
        xw.set("errX");
        xw.set("errYcolor", this.errorsColorY);
        xw.add("show", String.valueOf(this.errorsShowY));
        xw.add("penwidth", String.valueOf(this.penWidthErr));
        xw.set("errY");
        xw.set("errSysXcolor", this.errorsColorSysX);
        xw.add("show", String.valueOf(this.errorsShowSysX));
        xw.add("penwidth", String.valueOf(this.penWidthErrSys));
        xw.set("errSysX");
        xw.set("errSysYcolor", this.errorsColorSysY);
        xw.add("show", String.valueOf(this.errorsShowSysY));
        xw.add("penwidth", String.valueOf(this.penWidthErrSys));
        xw.set("errSysY");
        xw.set("errFillColor", this.errorsFillColor);
        xw.add("fill", String.valueOf(this.errorsFill));
        xw.add("transp", String.valueOf(this.errorsFillColorTransp));
        xw.set("errFill");
        xw.set("errFillColorSys", this.errorsFillColorSys);
        xw.add("fill", String.valueOf(this.errorsFillSys));
        xw.add("transp", String.valueOf(this.errorsFillColorTranspSys));
        xw.set("errFillSys");
        xw.add("show", String.valueOf(this.useSymbol));
        xw.add("symbol", String.valueOf(this.symbol));
        xw.add("size", String.valueOf(this.symbolSize));
        xw.add("every", String.valueOf(this.every));
        xw.set("point");
        xw.add("show", String.valueOf(this.showLegend));
        xw.add("text", this.name);
        xw.set("legend");
        xw.add("multiplier", String.valueOf(this.multiplier));
        xw.add("offset", String.valueOf(this.additioner));
        xw.set("scaling");
    }

    public boolean dataChanged() {
        return this.dataModified;
    }

    public void setDataChanged(boolean b) {
        this.dataModified = b;
    }

    public void updateSettings(XMLRead xr) {
        this.style = xr.getInt("style", this.style);
        this.type = xr.getInt("type", this.style);
        this.color = xr.getColor("color", this.color);
        this.plotLine = xr.getBoolean("line/show", this.plotLine);
        this.dashIndex = xr.getInt("line/dash", this.dashIndex);
        this.penWidth = xr.getFloat("line/width", this.penWidth);
        this.fillColor = xr.getColor("fillAreaColor", this.fillColor);
        this.fillArea = xr.getBoolean("fillArea/fill", this.fillArea);
        this.fillBars = xr.getBoolean("fillArea/isbarshown", this.fillBars);
        this.fillColorTransparency = xr.getFloat("fillArea/transp", this.fillColorTransparency);
        this.errorsColorX = xr.getColor("errXcolor", this.errorsColorX);
        this.errorsShowX = xr.getBoolean("errX/show", this.errorsShowX);
        this.penWidthErr = xr.getFloat("errX/penwidth", this.penWidthErr);
        this.errorsColorY = xr.getColor("errYcolor", this.errorsColorY);
        this.errorsShowY = xr.getBoolean("errY/show", this.errorsShowY);
        this.penWidthErr = xr.getFloat("errY/penwidth", this.penWidthErr);
        this.errorsColorSysX = xr.getColor("errSysXcolor", this.errorsColorSysX);
        this.errorsShowSysX = xr.getBoolean("errSysX/show", this.errorsShowSysX);
        this.penWidthErrSys = xr.getFloat("errSysX/penwidth", this.penWidthErrSys);
        this.errorsColorSysY = xr.getColor("errSysYcolor", this.errorsColorSysY);
        this.errorsShowSysY = xr.getBoolean("errSysY/show", this.errorsShowSysY);
        this.penWidthErrSys = xr.getFloat("errSysX/penwidth", this.penWidthErrSys);
        this.errorsFillColor = xr.getColor("errFillColor", this.errorsFillColor);
        this.errorsFill = xr.getBoolean("errFill/fill", this.errorsFill);
        this.errorsFillColorTransp = xr.getFloat("errFill/transp", this.errorsFillColorTransp);
        this.errorsFillColorSys = xr.getColor("errFillColorSys", this.errorsFillColorSys);
        this.errorsFillSys = xr.getBoolean("errFillSys/fill", this.errorsFillSys);
        this.errorsFillColorTranspSys = xr.getFloat("errFillSys/transp", this.errorsFillColorTranspSys);
        this.useSymbol = xr.getBoolean("point/show", this.useSymbol);
        this.symbol = xr.getInt("point/symbol", this.symbol);
        this.symbolSize = xr.getFloat("line/size", this.symbolSize);
        this.every = xr.getInt("point/every", this.every);
        this.showLegend = xr.getBoolean("legend/show", this.showLegend);
        this.name = xr.getString("legend/text", "");
        this.additioner = xr.getFloat("scaling/offset", this.additioner);
        this.multiplier = xr.getFloat("scaling/multiplier", this.multiplier);
    }
}

