/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JPanel;
import jplot.Translate;
import jplot.Utils;
import jplot.XMLRead;
import jplot.XMLWrite;

public class GraphLabel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN = -1;
    public static final int XLABEL = 0;
    public static final int YLABEL = 1;
    public static final int TITLE = 2;
    public static final int PIPER_X1 = 3;
    public static final int PIPER_X2 = 4;
    public static final int PIPER_Y1 = 5;
    public static final int PIPER_Y2 = 6;
    public static final int PIPER_Y3 = 7;
    public static final int PIPER_Y4 = 8;
    public static final int DATA = 9;
    public static final int OTHER = 10;
    public static final int CHECK = 11;
    public static final int STATBOX = 12;
    public static final int KEY = 13;
    private int key_type;
    private Color key_color;
    private float key_size;
    private float key_space;
    private float key_line_width;
    private String[] multitext;
    private int multilines;
    private String text;
    private Font font;
    private Color color;
    private boolean active;
    private boolean usePos;
    private boolean usePosData;
    private FontMetrics fm;
    private double rotation;
    private int whoAmI;
    private double xPos;
    private double yPos;
    private double bbX;
    private double bbY;
    private double textWidth;
    private double textHeight;
    private double textDescent;
    private double bbWidth;
    private double bbHeight;
    private double sin;
    private double cos;
    private AttributedString attributedString;
    private File file;
    private boolean hideLabel;

    public GraphLabel(int t, String s, Font f, Color c) {
        this.font = f;
        this.color = c;
        this.usePos = false;
        this.usePosData = false;
        this.active = false;
        this.rotation = 0.0;
        this.multitext = new String[20];
        this.multilines = 20;
        this.sin = 0.0;
        this.hideLabel = false;
        this.cos = 1.0;
        this.yPos = 0.0;
        this.xPos = 0.0;
        this.bbY = 0.0;
        this.bbX = 0.0;
        this.bbHeight = 0.0;
        this.bbWidth = 0.0;
        this.file = null;
        this.key_type = 0;
        this.key_color = Color.blue;
        this.key_size = 5.0f;
        this.key_space = 2.0f;
        this.key_line_width = 2.0f;
        this.setID(t);
        this.setFont(f);
        this.setText(s);
    }

    public GraphLabel(int t, Font f, Color c) {
        this(t, " ", f, c);
    }

    public void setKey(int key_type, float key_size, Color key_color) {
        this.key_type = key_type;
        this.key_size = key_size;
        this.key_color = key_color;
        this.setSpace();
    }

    public void setKeyLineWidth(float key_line_width) {
        this.key_line_width = key_line_width;
    }

    public Color getKeyColor() {
        return this.key_color;
    }

    public float getKeySize() {
        return this.key_size;
    }

    public float getKeyLineWidth() {
        return this.key_line_width;
    }

    public int getKeyType() {
        return this.key_type;
    }

    public float getKeySpace() {
        return this.key_space;
    }

    public void setKeySpace(float key_space) {
        this.key_space = key_space;
        this.setSpace();
    }

    private void setBoundingBox() {
        if (this.getID() == 12) {
            this.setSize(this.textWidth, (double)this.getMultiLines() * this.textHeight);
            return;
        }
        if (this.rotation != 0.0) {
            this.setSize(this.textWidth * this.cos + this.textHeight * this.sin, this.textHeight * this.cos + this.textWidth * this.sin);
        } else {
            this.setSize(this.textWidth, this.textHeight);
        }
    }

    private void setTextMetrics() {
        if (this.getID() == 12) {
            String[] ss = this.getMultiText();
            if (ss[0] != null) {
                String tmp0 = Translate.shrink(ss[0]);
                double width = this.fm.stringWidth(tmp0);
                this.attributedString = new AttributedString(tmp0);
                this.attributedString.addAttribute(TextAttribute.FONT, this.font);
                if (this.fm == null) {
                    this.fm = new JPanel().getFontMetrics(this.font);
                }
                this.textHeight = this.fm.getHeight();
                this.textDescent = this.fm.getDescent();
                for (int i = 1; i < ss.length; ++i) {
                    String stmp = Translate.shrink(ss[i]);
                    double dd = this.fm.stringWidth(stmp);
                    if (!(dd > width)) continue;
                    width = dd;
                }
                this.textWidth = width;
                this.setBoundingBox();
            }
        } else if (this.text != null && !this.text.equals("")) {
            this.attributedString = new AttributedString(this.text);
            this.attributedString.addAttribute(TextAttribute.FONT, this.font);
            if (this.fm == null) {
                this.fm = new JPanel().getFontMetrics(this.font);
            }
            String tmp = Translate.shrink(this.text);
            this.textWidth = this.fm.stringWidth(tmp);
            this.textHeight = this.fm.getHeight();
            this.textDescent = this.fm.getDescent();
            this.setBoundingBox();
        } else {
            this.textHeight = 0.0;
            this.textWidth = 0.0;
        }
    }

    public GraphLabel(int t, String s) {
        this(t, s, Utils.getDefaultFont(), Color.black);
    }

    public GraphLabel(String s) {
        this(-1, s);
    }

    public GraphLabel(int t) {
        this(t, "");
    }

    public GraphLabel() {
        this("");
    }

    public GraphLabel(GraphLabel gl) {
        this.copy(gl);
    }

    public void copy(GraphLabel gl) {
        this.bbX = gl.getX();
        this.bbY = gl.getY();
        this.bbWidth = gl.getWidth();
        this.bbHeight = gl.getHeight();
        this.active = gl.isActive();
        this.usePos = gl.usePosition();
        this.setRotation(gl.getRotation());
        this.setID(gl.getID());
        this.hideLabel = gl.hide();
        this.xPos = gl.getXPos();
        this.yPos = gl.getYPos();
        this.key_size = gl.getKeySize();
        this.key_color = gl.getKeyColor();
        this.key_type = gl.getKeyType();
        this.key_space = gl.getKeySpace();
        this.key_line_width = gl.getKeyLineWidth();
        this.multitext = gl.getMultiText();
        this.textWidth = gl.getTextWidth();
        this.textHeight = gl.getTextHeight();
        this.textDescent = gl.getTextDescent();
        this.file = gl.getFile();
        this.setFont(new Font(gl.getFont().getName(), gl.getFont().getStyle(), gl.getFont().getSize()));
        this.color = new Color(gl.getColor().getRed(), gl.getColor().getGreen(), gl.getColor().getBlue());
        this.setText(gl.getText());
    }

    public void setSpace() {
        if (this.getID() != 13) {
            return;
        }
        this.text = this.text.replaceAll("^\\s+", "");
        String tmp = "";
        int k = 0;
        while ((float)k < this.key_size + this.key_space) {
            tmp = tmp + " ";
            ++k;
        }
        this.text = tmp + this.text;
        this.setTextMetrics();
        this.setLocation(this.bbX, this.bbY);
    }

    public void setText(String s) {
        this.text = s;
        this.setTextMetrics();
        this.setLocation(this.bbX, this.bbY);
    }

    public void setText(String[] s) {
        if (s.length < 20) {
            this.multilines = s.length;
            this.multitext = s;
            this.setTextMetrics();
            this.setLocation(this.bbX, this.bbY);
        } else {
            System.out.println("too many lines for multilabel");
        }
    }

    public String[] getMultiText() {
        return this.multitext;
    }

    public int getMultiLines() {
        return this.multilines;
    }

    public String getText() {
        String tmp = this.text;
        if (this.getID() == 12) {
            String[] ss = this.getMultiText();
            String tt = "";
            for (int i = 0; i < ss.length; ++i) {
                tt = tt + ss[i] + " ";
            }
            tmp = tt;
        }
        return tmp;
    }

    public AttributedCharacterIterator getCharIterator() {
        return this.attributedString.getIterator();
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public void setFont(Font f) {
        this.font = f;
        this.fm = new JPanel().getFontMetrics(this.font);
        this.setTextMetrics();
    }

    public Font getFont() {
        return this.font;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setUsePosition(boolean b) {
        this.usePos = b;
    }

    public void setUseDataPosition(boolean b) {
        this.usePosData = b;
    }

    public boolean usePosition() {
        return this.usePos;
    }

    public boolean useDataPosition() {
        return this.usePosData;
    }

    public boolean hide() {
        return this.hideLabel;
    }

    public void hide(boolean h) {
        this.hideLabel = h;
    }

    public boolean equals(int type) {
        return type == this.whoAmI;
    }

    public boolean equals(String name) {
        return this.text.equals(name);
    }

    public void setID(int type) {
        this.whoAmI = type;
    }

    public int getID() {
        return this.whoAmI;
    }

    public void setDataRotation(double r) {
        this.rotation = r;
    }

    public void setRotation(double r) {
        this.rotation = r;
        while (this.rotation < 0.0) {
            this.rotation += Math.PI * 2;
        }
        while (this.rotation > Math.PI * 2) {
            this.rotation -= Math.PI * 2;
        }
        if (this.rotation != 0.0) {
            this.sin = Math.abs(Math.sin(this.rotation));
            this.cos = Math.abs(Math.cos(this.rotation));
        } else {
            this.sin = 0.0;
            this.cos = 1.0;
        }
        this.setBoundingBox();
        this.setLocation(this.bbX, this.bbY);
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setLocation(double x, double y) {
        this.bbX = x;
        this.bbY = y;
        if (this.rotation <= 1.5707963267948966) {
            this.xPos = x;
            this.yPos = y + this.textHeight * this.cos;
            return;
        }
        if (this.rotation <= Math.PI) {
            this.xPos = x + this.getWidth() - this.textHeight * this.sin;
            this.yPos = y;
            return;
        }
        if (this.rotation <= 4.71238898038469) {
            this.xPos = x + this.getWidth();
            this.yPos = y + this.getHeight() - this.textHeight * this.cos;
            return;
        }
        if (this.rotation <= Math.PI * 2) {
            this.xPos = x + this.textHeight * this.sin;
            this.yPos = y + this.getHeight();
            return;
        }
    }

    public void setDataLocation(double x, double y) {
        this.xPos = x;
        this.yPos = y;
    }

    public double getXPos() {
        return this.xPos;
    }

    public double getYPos() {
        return this.yPos;
    }

    public double getX() {
        return this.bbX;
    }

    public double getY() {
        return this.bbY;
    }

    public void setSize(double w, double h) {
        this.bbWidth = w;
        this.bbHeight = h;
    }

    public void setTextSize(double w, double h) {
        this.textWidth = w;
        this.textHeight = h;
    }

    public double getWidth() {
        return this.bbWidth;
    }

    public double getHeight() {
        return this.bbHeight;
    }

    public double getTextWidth() {
        return this.textWidth;
    }

    public double getTextHeight() {
        return this.textHeight;
    }

    public double getTextDescent() {
        return this.textDescent;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public String toString() {
        return this.text;
    }

    public boolean contains(double x, double y) {
        return x > this.bbX && x < this.bbX + this.bbWidth && y > this.bbY && y < this.bbY + this.bbHeight;
    }

    public boolean contains(double x, double y, float scale) {
        return x > this.bbX && x < this.bbX + this.bbWidth * (double)scale && y > this.bbY && y < this.bbY + this.bbHeight * (double)scale;
    }

    public void getSettings(XMLWrite xw) {
        xw.add("name", String.valueOf(this.text));
        String type = "";
        if (this.whoAmI == 0) {
            type = "x-label";
        } else if (this.whoAmI == 1) {
            type = "y-label";
        } else if (this.whoAmI == 2) {
            type = "title";
        } else if (this.whoAmI == 3) {
            type = "piper-x1";
        } else if (this.whoAmI == 4) {
            type = "piper-x2";
        } else if (this.whoAmI == 5) {
            type = "piper-y1";
        } else if (this.whoAmI == 6) {
            type = "piper-y2";
        } else if (this.whoAmI == 7) {
            type = "piper-y3";
        } else if (this.whoAmI == 8) {
            type = "piper-y4";
        } else if (this.whoAmI == 9) {
            type = "data";
        } else if (this.whoAmI == 10) {
            type = "other";
        } else if (this.whoAmI == 11) {
            type = "check";
        } else if (this.whoAmI == 12) {
            type = "statbox";
        } else if (this.whoAmI == 13) {
            type = "key";
        }
        xw.add("type", type);
        xw.open("label");
        xw.set("color", this.color);
        xw.set("font", this.font);
        xw.add("fix", String.valueOf(this.usePos));
        xw.add("x", String.valueOf((int)this.bbX));
        xw.add("y", String.valueOf((int)this.bbY));
        xw.set("key-color", this.key_color);
        xw.add("key-type", String.valueOf(this.key_type));
        xw.add("key-size", String.valueOf(this.key_size));
        xw.add("key-space", String.valueOf(this.key_space));
        xw.add("key-line_width", String.valueOf(this.key_line_width));
        xw.set("position");
        xw.add("degrees", String.valueOf((int)(this.rotation / Math.PI * 180.0)));
        xw.set("rotation");
        xw.close();
    }

    public void updateSettings(XMLRead xr) {
        String type = xr.getString("type", "");
        if (type.equals("x-label")) {
            this.whoAmI = 0;
        }
        if (type.equals("y-label")) {
            this.whoAmI = 1;
        }
        if (type.equals("title")) {
            this.whoAmI = 2;
        }
        if (type.equals("piper-x1")) {
            this.whoAmI = 3;
        }
        if (type.equals("piper-x2")) {
            this.whoAmI = 4;
        }
        if (type.equals("piper-y1")) {
            this.whoAmI = 5;
        }
        if (type.equals("piper-y2")) {
            this.whoAmI = 6;
        }
        if (type.equals("piper-y3")) {
            this.whoAmI = 7;
        }
        if (type.equals("piper-y4")) {
            this.whoAmI = 8;
        }
        if (type.equals("data")) {
            this.whoAmI = 9;
        }
        if (type.equals("other")) {
            this.whoAmI = 10;
        }
        if (type.equals("check")) {
            this.whoAmI = 11;
        }
        if (type.equals("statbox")) {
            this.whoAmI = 12;
        }
        if (type.equals("key")) {
            this.whoAmI = 13;
        }
        this.color = xr.getColor("color", this.color);
        this.font = xr.getFont("font", this.font);
        this.fm = new JPanel().getFontMetrics(this.font);
        this.usePos = xr.getBoolean("position/fix", this.usePos);
        this.bbX = xr.getDouble("position/x", this.bbX);
        this.bbY = xr.getDouble("position/y", this.bbY);
        this.key_size = (float)xr.getDouble("key-size", this.key_size);
        this.key_line_width = (float)xr.getDouble("key-line_width", this.key_line_width);
        this.key_space = (float)xr.getDouble("key-space", this.key_space);
        this.key_type = xr.getInt("key-type", this.key_type);
        this.key_color = xr.getColor("key-color", this.key_color);
        double rot = xr.getDouble("rotation/degrees", 0.0);
        this.setRotation(rot * Math.PI / 180.0);
        this.setLocation(this.bbX, this.bbY);
        this.setText(xr.getString("name", ""));
    }
}

