/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import jhplot.v3d.Object3d;
import jhplot.v3d.Vector3d;

class Face3d {
    Object3d obj;
    Vector3d[] vert;
    Vector3d center;
    Vector3d normal;
    int nvert;
    int cvert;
    int red;
    int green;
    int blue;
    boolean dummy = false;

    Face3d(Object3d obj, int nvert, Color c) {
        this.obj = obj;
        this.nvert = nvert;
        this.red = c.getRed();
        this.green = c.getGreen();
        this.blue = c.getBlue();
        if (nvert < 3) {
            return;
        }
        this.vert = new Vector3d[nvert];
        this.center = new Vector3d();
        this.cvert = 0;
    }

    Face3d(Object3d obj, int nvert, int red, int green, int blue) {
        this(obj, nvert, new Color(red, green, blue));
    }

    Face3d(Object3d obj, int nvert) {
        this(obj, nvert, 0, 0, 0);
        this.dummy = true;
    }

    int addVertex(Vector3d v) {
        if (this.cvert >= this.nvert) {
            return -1;
        }
        this.vert[this.cvert] = v;
        if (this.cvert == this.nvert - 1) {
            this.computeNormal();
        }
        return this.cvert++;
    }

    void setColor(Color c) {
        this.setColor(c.getRed(), c.getGreen(), c.getBlue());
    }

    void setColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    boolean visible() {
        if (this.normal == null) {
            return false;
        }
        if (this.obj.md.persp) {
            return this.center.dot(this.normal) < 0.0f;
        }
        return this.normal.z > 0.0f;
    }

    void paint(Graphics g) {
        if (this.dummy) {
            return;
        }
        if (this.cvert != this.nvert) {
            return;
        }
        float a = this.obj.md.ambient;
        float z = this.obj.md.persp ? -this.center.dot(this.normal) : this.normal.z;
        z *= 1.0f - a;
        int ir = (int)((a *= 255.0f) + z * (float)this.red);
        int ig = (int)(a + z * (float)this.green);
        int ib = (int)(a + z * (float)this.blue);
        Color color = new Color(ir, ig, ib);
        g.setColor(color);
        int[] xvert = new int[this.nvert];
        int[] yvert = new int[this.nvert];
        for (int i = 0; i < this.nvert; ++i) {
            Vector3d v = this.vert[i];
            xvert[i] = (int)v.x;
            yvert[i] = (int)v.y;
        }
        g.fillPolygon(xvert, yvert, this.nvert);
    }

    boolean inside(int x, int y) {
        if (this.dummy) {
            return false;
        }
        if (this.cvert != this.nvert) {
            return false;
        }
        int[] xvert = new int[this.nvert];
        int[] yvert = new int[this.nvert];
        for (int i = 0; i < this.nvert; ++i) {
            Vector3d v = this.vert[i];
            xvert[i] = (int)v.x;
            yvert[i] = (int)v.y;
        }
        Polygon p = new Polygon(xvert, yvert, this.nvert);
        return p.inside(x, y);
    }

    void computeCenter() {
        Vector3d c = this.center;
        c.set(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < this.nvert; ++i) {
            c.add(this.vert[i]);
        }
        c.div(this.nvert);
        c.normalize();
    }

    void computeNormal() {
        this.normal = new Vector3d(0.0f, 0.0f, 0.0f);
        Vector3d w = new Vector3d(this.vert[0]);
        w.sub(this.vert[this.nvert - 1]);
        for (int i = 0; i < this.nvert - 1; ++i) {
            Vector3d v = new Vector3d(this.vert[i + 1]);
            v.sub(this.vert[i]);
            w.mul(v);
            this.normal.add(w);
            w = v;
        }
        Vector3d v = new Vector3d(this.vert[0]);
        v.sub(this.vert[this.nvert - 1]);
        w.mul(v);
        this.normal.add(w);
        this.normal.normalize();
    }
}

