/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.special;

import jhplot.math.num.Function;
import jhplot.math.num.NumericException;
import jhplot.math.num.root.BisectionRootFinder;
import jhplot.math.num.root.Bracket;
import jhplot.math.num.special.Gamma;

public final class Erf {
    private Erf() {
    }

    public static double erf(double x) throws NumericException {
        double ret;
        if (Double.isNaN(x)) {
            ret = Double.NaN;
        } else if (Double.isInfinite(x)) {
            ret = x < 0.0 ? -1.0 : 1.0;
        } else if (x == 0.0) {
            ret = 0.0;
        } else {
            ret = Gamma.regularizedGammaP(0.5, x * x);
            if (x < 0.0) {
                ret = -ret;
            }
        }
        return ret;
    }

    public static double erfc(double x) throws NumericException {
        double ret = Double.isNaN(x) ? Double.NaN : (Double.isInfinite(x) ? (x < 0.0 ? 2.0 : 0.0) : (x == 0.0 ? 1.0 : (x < 0.0 ? 1.0 + Gamma.regularizedGammaP(0.5, x * x) : Gamma.regularizedGammaQ(0.5, x * x))));
        return ret;
    }

    public static double inverseErf(final double y) throws NumericException {
        double ret;
        if (Double.isNaN(y) || y < -1.0 || y > 1.0) {
            ret = Double.NaN;
        } else if (y == 1.0) {
            ret = Double.POSITIVE_INFINITY;
        } else if (y == -1.0) {
            ret = Double.NEGATIVE_INFINITY;
        } else if (y == 0.0) {
            ret = 0.0;
        } else {
            Function f = new Function(){

                @Override
                public double evaluate(double x) throws NumericException {
                    return Erf.erf(x) - y;
                }
            };
            Bracket b = new Bracket(f);
            double[] bracket = y > 0.0 ? b.bracketOut(0.0, y, Double.POSITIVE_INFINITY) : b.bracketOut(Double.NEGATIVE_INFINITY, y, 0.0);
            BisectionRootFinder bisection = new BisectionRootFinder(f);
            ret = bisection.findRoot(bracket[0], bracket[1]);
        }
        return ret;
    }
}

