/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractContinuousRandomVariable;
import jhplot.math.num.random.GammaRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class ChiSquaredRandomVariable
extends AbstractContinuousRandomVariable {
    private double degreesOfFreedom;

    public ChiSquaredRandomVariable() {
        this(1.0);
    }

    public ChiSquaredRandomVariable(double df) {
        this(df, new RandomRNG());
    }

    public ChiSquaredRandomVariable(double df, RNG source) {
        super(source);
        this.setDegreesOfFreedom(df);
    }

    public static double nextRandomVariable(double df, RNG source) {
        return GammaRandomVariable.nextRandomVariable(df / 2.0, 2.0, source);
    }

    private double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double nextRandomVariable() {
        return ChiSquaredRandomVariable.nextRandomVariable(this.getDegreesOfFreedom(), this.getSource());
    }

    private void setDegreesOfFreedom(double m) {
        if (m <= 0.0 || Double.isNaN(m)) {
            throw new IllegalArgumentException("Degrees of freedom must be positive.");
        }
        this.degreesOfFreedom = m;
    }
}

