/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractDiscreteRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class BernoulliRandomVariable
extends AbstractDiscreteRandomVariable {
    private double probabilityOfSuccess;

    public BernoulliRandomVariable() {
        this(0.5);
    }

    public BernoulliRandomVariable(double p) {
        this(p, new RandomRNG());
    }

    public BernoulliRandomVariable(double p, RNG source) {
        super(source);
        this.setProbabilityOfSuccess(p);
    }

    public static int nextRandomVariable(double p, RNG source) {
        return p <= source.nextRandomNumber() ? 1 : 0;
    }

    private double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public int nextRandomVariable() {
        return BernoulliRandomVariable.nextRandomVariable(this.getProbabilityOfSuccess(), this.getSource());
    }

    private void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

