/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.pdf;

import jhplot.math.num.pdf.ContinuousDistribution;

public class Laplace
extends ContinuousDistribution {
    private double mean;
    private double scale;

    public Laplace() {
        this(0.0, 1.0);
    }

    public Laplace(double m, double s) {
        this.setMean(m);
        this.setScale(s);
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret = Double.isNaN(x) ? Double.NaN : (Double.isInfinite(x) ? (x < 0.0 ? 0.0 : 1.0) : (x < this.mean ? 0.5 * Math.exp((x - this.mean) / this.scale) : 0.5 * (2.0 - Math.exp((this.mean - x) / this.scale))));
        return ret;
    }

    public double getMean() {
        return this.mean;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : (p < 0.5 ? this.mean + this.scale * Math.log(1.0 + (2.0 * p - 1.0)) : this.mean - this.scale * Math.log(1.0 - (2.0 * p - 1.0)))));
        return ret;
    }

    public void setMean(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("mean must be a number.");
        }
        this.mean = m;
    }

    public void setScale(double s) {
        if (s <= 0.0 || Double.isNaN(s)) {
            throw new IllegalArgumentException("scale must be positive.");
        }
        this.scale = s;
    }
}

