/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

public class KolmogorovSmirnovDist {
    private static final double num_Ln2 = 0.6931471805599453;
    private static final double PI2 = Math.PI * Math.PI;
    private static final double PI4 = 97.40909103400243;
    private static final int NFACT = 20;
    private static final int MFACT = 30;
    private static final int NEXACT = 140;
    private static final int NKOLMO = 100000;
    private static final double NORM = 1.0E140;
    private static final double INORM = 1.0E-140;
    private static final int LOGNORM = 140;
    private static final double[] Factorial = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18};
    private static final double[] LnFactorial = new double[]{0.0, 0.0, 0.6931471805599453, 1.791759469228055, 3.178053830347946, 4.787491742782046, 6.579251212010101, 8.525161361065415, 10.60460290274525, 12.80182748008147, 15.10441257307552, 17.50230784587389, 19.98721449566188, 22.55216385312342, 25.19122118273868, 27.89927138384088, 30.67186010608066, 33.50507345013688, 36.39544520803305, 39.33988418719949, 42.33561646075348, 45.3801388984769, 48.47118135183522, 51.60667556776437, 54.7847293981123, 58.00360522298051, 61.26170176100199, 64.55753862700632, 67.88974313718154, 71.257038967168, 74.65823634883016};

    private static double getLogFactorial(int n) {
        if (n <= 30) {
            return LnFactorial[n];
        }
        double x = n + 1;
        double y = 1.0 / (x * x);
        double z = ((-(5.95238095238E-4 * y) + 7.936500793651E-4) * y - 0.0027777777777778) * y + 0.083333333333333;
        z = (x - 0.5) * Math.log(x) - x + 0.91893853320467 + z / x;
        return z;
    }

    private static double KSPlusbarAsymp(int n, double x) {
        double t = 6.0 * (double)n * x + 1.0;
        double z = t * t / (18.0 * (double)n);
        double v = 1.0 - (2.0 * z * z - 4.0 * z - 1.0) / (18.0 * (double)n);
        if (v <= 0.0) {
            return 0.0;
        }
        if ((v *= Math.exp(-z)) >= 1.0) {
            return 1.0;
        }
        return v;
    }

    private static double KSPlusbarUpper(int n, double x) {
        double t;
        double term;
        double q;
        int j;
        double LogCom;
        if (n > 200000) {
            return KolmogorovSmirnovDist.KSPlusbarAsymp(n, x);
        }
        int jmax = (int)((double)n * (1.0 - x));
        if (1.0 - x - (double)jmax / (double)n <= 0.0) {
            --jmax;
        }
        int jdiv = n > 3000 ? 2 : 3;
        double LOGJMAX = LogCom = KolmogorovSmirnovDist.getLogFactorial(n) - KolmogorovSmirnovDist.getLogFactorial(j) - KolmogorovSmirnovDist.getLogFactorial(n - j);
        double EPSILON = 1.0E-12;
        double Sum = 0.0;
        for (j = jmax / jdiv + 1; j <= jmax; ++j) {
            q = (double)j / (double)n + x;
            term = LogCom + (double)(j - 1) * Math.log(q) + (double)(n - j) * Math.log1p(-q);
            t = Math.exp(term);
            LogCom += Math.log((double)(n - j) / (double)(j + 1));
            if (t <= (Sum += t) * 1.0E-12) break;
        }
        LogCom = LOGJMAX + Math.log((double)(j + 1) / (double)(n - j));
        for (j = jmax / jdiv; j > 0; --j) {
            q = (double)j / (double)n + x;
            term = LogCom + (double)(j - 1) * Math.log(q) + (double)(n - j) * Math.log1p(-q);
            t = Math.exp(term);
            LogCom += Math.log((double)j / (double)(n - j + 1));
            if (t <= (Sum += t) * 1.0E-12) break;
        }
        Sum *= x;
        return Sum += Math.exp((double)n * Math.log1p(-x));
    }

    private static double Pelz(int n, double x) {
        double ti;
        int j;
        int JMAX = 20;
        double EPS = 1.0E-10;
        double C = 2.506628274631001;
        double C2 = 1.2533141373155001;
        double RACN = Math.sqrt(n);
        double z = RACN * x;
        double z2 = z * z;
        double z4 = z2 * z2;
        double z6 = z4 * z2;
        double w = Math.PI * Math.PI / (2.0 * z * z);
        double term = 1.0;
        double sum = 0.0;
        for (j = 0; j <= 20 && term > 1.0E-10 * sum; ++j) {
            ti = (double)j + 0.5;
            term = Math.exp(-ti * ti * w);
            sum += term;
        }
        sum *= 2.506628274631001 / z;
        term = 1.0;
        double tom = 0.0;
        for (j = 0; j <= 20 && Math.abs(term) > 1.0E-10 * Math.abs(tom); ++j) {
            ti = (double)j + 0.5;
            term = (Math.PI * Math.PI * ti * ti - z2) * Math.exp(-ti * ti * w);
            tom += term;
        }
        sum += tom * 1.2533141373155001 / (RACN * 3.0 * z4);
        term = 1.0;
        tom = 0.0;
        for (j = 0; j <= 20 && Math.abs(term) > 1.0E-10 * Math.abs(tom); ++j) {
            ti = (double)j + 0.5;
            term = 6.0 * z6 + 2.0 * z4 + Math.PI * Math.PI * (2.0 * z4 - 5.0 * z2) * ti * ti + 97.40909103400243 * (1.0 - 2.0 * z2) * ti * ti * ti * ti;
            tom += (term *= Math.exp(-ti * ti * w));
        }
        sum += tom * 1.2533141373155001 / ((double)n * 36.0 * z * z6);
        term = 1.0;
        tom = 0.0;
        for (j = 1; j <= 20 && term > 1.0E-10 * tom; ++j) {
            ti = j;
            term = Math.PI * Math.PI * ti * ti * Math.exp(-ti * ti * w);
            tom += term;
        }
        sum -= tom * 1.2533141373155001 / ((double)n * 18.0 * z * z2);
        term = 1.0;
        tom = 0.0;
        for (j = 0; j <= 20 && Math.abs(term) > 1.0E-10 * Math.abs(tom); ++j) {
            ti = (double)j + 0.5;
            ti *= ti;
            term = -30.0 * z6 - 90.0 * z6 * z2 + Math.PI * Math.PI * (135.0 * z4 - 96.0 * z6) * ti + 97.40909103400243 * (212.0 * z4 - 60.0 * z2) * ti * ti + 961.3891935753043 * ti * ti * ti * (5.0 - 30.0 * z2);
            tom += (term *= Math.exp(-ti * w));
        }
        sum += tom * 1.2533141373155001 / (RACN * (double)n * 3240.0 * z4 * z6);
        term = 1.0;
        tom = 0.0;
        for (j = 1; j <= 20 && Math.abs(term) > 1.0E-10 * Math.abs(tom); ++j) {
            ti = j * j;
            term = (29.608813203268074 * ti * z2 - 97.40909103400243 * ti * ti) * Math.exp(-ti * w);
            tom += term;
        }
        return sum += tom * 1.2533141373155001 / (RACN * (double)n * 108.0 * z6);
    }

    private static void CalcFloorCeil(int n, double t, double[] A, double[] Atflo, double[] Atcei) {
        int i;
        int ell = (int)t;
        double z = t - (double)ell;
        double w = Math.ceil(t) - t;
        if (z > 0.5) {
            for (i = 2; i <= 2 * n + 2; i += 2) {
                Atflo[i] = i / 2 - 2 - ell;
            }
            for (i = 1; i <= 2 * n + 2; i += 2) {
                Atflo[i] = i / 2 - 1 - ell;
            }
            for (i = 2; i <= 2 * n + 2; i += 2) {
                Atcei[i] = i / 2 + ell;
            }
            for (i = 1; i <= 2 * n + 2; i += 2) {
                Atcei[i] = i / 2 + 1 + ell;
            }
        } else if (z > 0.0) {
            for (i = 1; i <= 2 * n + 2; ++i) {
                Atflo[i] = i / 2 - 1 - ell;
            }
            for (i = 2; i <= 2 * n + 2; ++i) {
                Atcei[i] = i / 2 + ell;
            }
            Atcei[1] = 1 + ell;
        } else {
            for (i = 2; i <= 2 * n + 2; i += 2) {
                Atflo[i] = i / 2 - 1 - ell;
            }
            for (i = 1; i <= 2 * n + 2; i += 2) {
                Atflo[i] = i / 2 - ell;
            }
            for (i = 2; i <= 2 * n + 2; i += 2) {
                Atcei[i] = i / 2 - 1 + ell;
            }
            for (i = 1; i <= 2 * n + 2; i += 2) {
                Atcei[i] = i / 2 + ell;
            }
        }
        if (w < z) {
            z = w;
        }
        A[1] = 0.0;
        A[0] = 0.0;
        A[2] = z;
        A[3] = 1.0 - A[2];
        for (i = 4; i <= 2 * n + 1; ++i) {
            A[i] = A[i - 2] + 1.0;
        }
        A[2 * n + 2] = n;
    }

    private static double Pomeranz(int n, double x) {
        double sum;
        int j;
        double EPS = 1.0E-15;
        int ENO = 350;
        double RENO = Math.scalb(1.0, 350);
        double t = (double)n * x;
        double[] A = new double[2 * n + 3];
        double[] Atflo = new double[2 * n + 3];
        double[] Atcei = new double[2 * n + 3];
        double[][] V = new double[2][n + 2];
        double[][] H = new double[4][n + 2];
        KolmogorovSmirnovDist.CalcFloorCeil(n, t, A, Atflo, Atcei);
        for (j = 1; j <= n + 1; ++j) {
            V[0][j] = 0.0;
        }
        for (j = 2; j <= n + 1; ++j) {
            V[1][j] = 0.0;
        }
        V[1][1] = RENO;
        int coreno = 1;
        H[0][0] = 1.0;
        double w = 2.0 * A[2] / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[0][j] = w * H[0][j - 1] / (double)j;
        }
        H[1][0] = 1.0;
        w = (1.0 - 2.0 * A[2]) / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[1][j] = w * H[1][j - 1] / (double)j;
        }
        H[2][0] = 1.0;
        w = A[2] / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[2][j] = w * H[2][j - 1] / (double)j;
        }
        H[3][0] = 1.0;
        for (j = 1; j <= n + 1; ++j) {
            H[3][j] = 0.0;
        }
        int r1 = 0;
        int r2 = 1;
        for (int i = 2; i <= 2 * n + 2; ++i) {
            int klow;
            int jup;
            int jlow = (int)(2.0 + Atflo[i]);
            if (jlow < 1) {
                jlow = 1;
            }
            if ((jup = (int)Atcei[i]) > n + 1) {
                jup = n + 1;
            }
            if ((klow = (int)(2.0 + Atflo[i - 1])) < 1) {
                klow = 1;
            }
            int kup0 = (int)Atcei[i - 1];
            w = (A[i] - A[i - 1]) / (double)n;
            int s = -1;
            for (j = 0; j < 4; ++j) {
                if (!(Math.abs(w - H[j][1]) <= 1.0E-15)) continue;
                s = j;
                break;
            }
            double minsum = RENO;
            r1 = r1 + 1 & 1;
            r2 = r2 + 1 & 1;
            for (j = jlow; j <= jup; ++j) {
                int kup = kup0;
                if (kup > j) {
                    kup = j;
                }
                sum = 0.0;
                for (int k = kup; k >= klow; --k) {
                    sum += V[r1][k] * H[s][j - k];
                }
                V[r2][j] = sum;
                if (!(sum < minsum)) continue;
                minsum = sum;
            }
            if (!(minsum < 1.0E-280)) continue;
            j = jlow;
            while (j <= jup) {
                double[] dArray = V[r2];
                int n2 = j++;
                dArray[n2] = dArray[n2] * RENO;
            }
            ++coreno;
        }
        sum = V[r2][n + 1];
        w = KolmogorovSmirnovDist.getLogFactorial(n) - (double)(coreno * 350) * 0.6931471805599453 + Math.log(sum);
        if (w >= 0.0) {
            return 1.0;
        }
        return Math.exp(w);
    }

    private static double cdfSpecial(int n, double x) {
        if ((double)n * x * x >= 18.0 || x >= 1.0) {
            return 1.0;
        }
        if (x <= 0.5 / (double)n) {
            return 0.0;
        }
        if (n == 1) {
            return 2.0 * x - 1.0;
        }
        if (x <= 1.0 / (double)n) {
            double t = 2.0 * x - 1.0 / (double)n;
            if (n <= 20) {
                double w = Factorial[n];
                return w * Math.pow(t, n);
            }
            double w = KolmogorovSmirnovDist.getLogFactorial(n) + (double)n * Math.log(t);
            return Math.exp(w);
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            return 1.0 - 2.0 * Math.pow(1.0 - x, n);
        }
        return -1.0;
    }

    public static double cdf(int n, double x) {
        double u = KolmogorovSmirnovDist.cdfSpecial(n, x);
        if (u >= 0.0) {
            return u;
        }
        double w = (double)n * x * x;
        if (n <= 140) {
            if (w < 0.754693) {
                return KolmogorovSmirnovDist.DurbinMatrix(n, x);
            }
            if (w < 4.0) {
                return KolmogorovSmirnovDist.Pomeranz(n, x);
            }
            return 1.0 - KolmogorovSmirnovDist.fbar(n, x);
        }
        if (w * x * (double)n <= 2.0 && n <= 100000) {
            return KolmogorovSmirnovDist.DurbinMatrix(n, x);
        }
        return KolmogorovSmirnovDist.Pelz(n, x);
    }

    private static double fbarSpecial(int n, double x) {
        double w = (double)n * x * x;
        if (w >= 370.0 || x >= 1.0) {
            return 0.0;
        }
        if (w <= 0.0274 || x <= 0.5 / (double)n) {
            return 1.0;
        }
        if (n == 1) {
            return 2.0 - 2.0 * x;
        }
        if (x <= 1.0 / (double)n) {
            double t = 2.0 * x - 1.0 / (double)n;
            if (n <= 20) {
                double v = Factorial[n];
                return 1.0 - v * Math.pow(t, n);
            }
            double v = KolmogorovSmirnovDist.getLogFactorial(n) + (double)n * Math.log(t);
            return 1.0 - Math.exp(v);
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            return 2.0 * Math.pow(1.0 - x, n);
        }
        return -1.0;
    }

    public static double fbar(int n, double x) {
        double v = KolmogorovSmirnovDist.fbarSpecial(n, x);
        if (v >= 0.0) {
            return v;
        }
        double w = (double)n * x * x;
        if (n <= 140) {
            if (w < 4.0) {
                return 1.0 - KolmogorovSmirnovDist.cdf(n, x);
            }
            return 2.0 * KolmogorovSmirnovDist.KSPlusbarUpper(n, x);
        }
        if (w >= 2.2) {
            return 2.0 * KolmogorovSmirnovDist.KSPlusbarUpper(n, x);
        }
        return 1.0 - KolmogorovSmirnovDist.cdf(n, x);
    }

    private static double DurbinMatrix(int n, double d) {
        int j;
        int i;
        int k = (int)((double)n * d) + 1;
        int m = 2 * k - 1;
        double h = (double)k - (double)n * d;
        double[] H = new double[m * m];
        double[] Q = new double[m * m];
        int[] pQ = new int[1];
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                H[i * m + j] = i - j + 1 < 0 ? 0.0 : 1.0;
            }
        }
        for (i = 0; i < m; ++i) {
            int n2 = i * m;
            H[n2] = H[n2] - Math.pow(h, i + 1);
            int n3 = (m - 1) * m + i;
            H[n3] = H[n3] - Math.pow(h, m - i);
        }
        int n4 = (m - 1) * m;
        H[n4] = H[n4] + (2.0 * h - 1.0 > 0.0 ? Math.pow(2.0 * h - 1.0, m) : 0.0);
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                if (i - j + 1 <= 0) continue;
                for (int g = 1; g <= i - j + 1; ++g) {
                    int n5 = i * m + j;
                    H[n5] = H[n5] / (double)g;
                }
            }
        }
        int eH = 0;
        KolmogorovSmirnovDist.mPower(H, eH, Q, pQ, m, n);
        double s = Q[(k - 1) * m + k - 1];
        for (i = 1; i <= n; ++i) {
            if (!((s = s * (double)i / (double)n) < 1.0E-140)) continue;
            s *= 1.0E140;
            pQ[0] = pQ[0] - 140;
        }
        return s *= Math.pow(10.0, pQ[0]);
    }

    private static void mMultiply(double[] A, double[] B, double[] C, int m) {
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                double s = 0.0;
                for (int k = 0; k < m; ++k) {
                    s += A[i * m + k] * B[k * m + j];
                }
                C[i * m + j] = s;
            }
        }
    }

    private static void renormalize(double[] V, int m, int[] p) {
        int i = 0;
        while (i < m * m) {
            int n = i++;
            V[n] = V[n] * 1.0E-140;
        }
        p[0] = p[0] + 140;
    }

    private static void mPower(double[] A, int eA, double[] V, int[] eV, int m, int n) {
        if (n == 1) {
            for (int i = 0; i < m * m; ++i) {
                V[i] = A[i];
            }
            eV[0] = eA;
            return;
        }
        KolmogorovSmirnovDist.mPower(A, eA, V, eV, m, n / 2);
        double[] B = new double[m * m];
        int[] pB = new int[1];
        KolmogorovSmirnovDist.mMultiply(V, V, B, m);
        pB[0] = 2 * eV[0];
        if (B[m / 2 * m + m / 2] > 1.0E140) {
            KolmogorovSmirnovDist.renormalize(B, m, pB);
        }
        if (n % 2 == 0) {
            for (int i = 0; i < m * m; ++i) {
                V[i] = B[i];
            }
            eV[0] = pB[0];
        } else {
            KolmogorovSmirnovDist.mMultiply(A, B, V, m);
            eV[0] = eA + pB[0];
        }
        if (V[m / 2 * m + m / 2] > 1.0E140) {
            KolmogorovSmirnovDist.renormalize(V, m, eV);
        }
    }

    public static void main(String[] args) {
        int K = 100;
        int n = 60;
        System.out.printf("n = %d%n%n", n);
        System.out.println("     x                    cdf                        fbar");
        for (int j = 0; j <= 100; ++j) {
            double x = (double)j / 100.0;
            double y = KolmogorovSmirnovDist.cdf(n, x);
            double z = KolmogorovSmirnovDist.fbar(n, x);
            System.out.printf("%8.3f     %22.15g      %22.15g%n", x, y, z);
        }
    }
}

