/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jhplot.F1D;
import jhplot.F2D;
import jhplot.F3D;
import jhplot.FND;
import jhplot.FProxy;
import jhplot.gui.HelpBrowser;
import jhplot.io.HFileMap;
import jhplot.utils.Util;

public class HFile {
    private FileOutputStream oof;
    private ObjectOutputStream oos;
    private ObjectInputStream iis;
    private int reset;
    private int nev;
    private int buffer;
    private Map<String, Object> hmap;
    private final int version = 2;

    public HFile(String file, String option, boolean compression, int bufferSize) {
        block18: {
            this.reset = 100;
            this.nev = 0;
            this.version = 2;
            this.buffer = bufferSize;
            this.nev = 0;
            file = file.trim();
            this.hmap = new HFileMap(2);
            if (option.equalsIgnoreCase("w")) {
                try {
                    new File(file).delete();
                    this.oof = new FileOutputStream(file);
                    if (compression) {
                        this.oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(this.oof), this.buffer));
                        break block18;
                    }
                    this.oos = new ObjectOutputStream(new BufferedOutputStream(this.oof, this.buffer));
                }
                catch (IOException e) {
                    Util.ErrorMessage((String)e.toString());
                }
            } else if (option.equalsIgnoreCase("r")) {
                if (file.startsWith("http") || file.startsWith("ftp")) {
                    URL url = null;
                    try {
                        url = new URL(file);
                    }
                    catch (MalformedURLException e) {
                        Util.ErrorMessage((String)e.toString());
                    }
                    try {
                        URLConnection urlConn = url.openConnection();
                        urlConn.setDoInput(true);
                        urlConn.setUseCaches(false);
                        if (compression) {
                            this.iis = new ObjectInputStream(new GZIPInputStream(urlConn.getInputStream()));
                            break block18;
                        }
                        this.iis = new ObjectInputStream(urlConn.getInputStream());
                    }
                    catch (MalformedURLException e) {
                        Util.ErrorMessage((String)e.toString());
                    }
                    catch (IOException e) {
                        Util.ErrorMessage((String)e.toString());
                    }
                } else {
                    try {
                        FileInputStream iif = new FileInputStream(new File(file));
                        if (compression) {
                            this.iis = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(iif), this.buffer));
                            break block18;
                        }
                        this.iis = new ObjectInputStream(new BufferedInputStream(iif, this.buffer));
                    }
                    catch (IOException e) {
                        Util.ErrorMessage((String)e.toString());
                    }
                }
            } else {
                Util.ErrorMessage((String)"Wrong option!. Only \"r\" or \"w\"  is allowed");
            }
        }
    }

    public HFile(String file, String option, boolean compression) {
        this(file, option, compression, 12288);
    }

    public int getBufferSize() {
        return this.buffer;
    }

    public HFile(String file) {
        this(file, "r", true);
    }

    public HFile(String file, String option) {
        this(file, option, true);
    }

    public boolean write(String key, Object ob) {
        if (!this.hmap.containsKey(key)) {
            this.hmap.put(key, ob);
            return true;
        }
        return false;
    }

    public boolean write(Object ob) {
        boolean success = true;
        if (ob instanceof F1D) {
            ob = ((F1D)ob).get();
        } else if (ob instanceof F2D) {
            ob = ((F2D)ob).get();
        } else if (ob instanceof F3D) {
            ob = ((F3D)ob).get();
        } else if (ob instanceof FND) {
            ob = ((FND)ob).get();
        }
        try {
            this.oos.writeObject(ob);
            ++this.nev;
            if (this.nev > 1 && this.nev % this.reset == 0) {
                this.oos.reset();
            }
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public void setFlush(int reset) {
        this.reset = reset;
    }

    public Map<String, Object> getObjectMap() {
        if (this.hmap.size() == 0 && this.iis != null) {
            try {
                Object obj = null;
                while ((obj = this.iis.readObject()) != null) {
                    if (!(obj instanceof HFileMap)) continue;
                    this.hmap = (HFileMap)obj;
                    return this.hmap;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                Util.ErrorMessage((String)e.toString());
                return null;
            }
        }
        return this.hmap;
    }

    public int getEntries() {
        return this.nev;
    }

    public Object read() {
        Object ob = null;
        try {
            ob = this.iis.readObject();
            if (ob instanceof FProxy) {
                if (((FProxy)ob).getType() == 1) {
                    ob = new F1D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 2) {
                    ob = new F2D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 3) {
                    ob = new F3D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 4) {
                    ob = new FND((FProxy)ob);
                }
            }
            if (ob instanceof HFileMap) {
                this.hmap = (HFileMap)ob;
                return null;
            }
            ++this.nev;
        }
        catch (IOException | ClassNotFoundException ex) {
            return null;
        }
        return ob;
    }

    public Object read(String key) {
        Object obj = null;
        if (this.hmap.size() == 0 && this.iis != null) {
            try {
                while ((obj = this.iis.readObject()) != null) {
                    if (!(obj instanceof HFileMap)) continue;
                    this.hmap = (HFileMap)obj;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                return null;
            }
        }
        if (this.hmap.containsKey(key)) {
            return this.hmap.get(key);
        }
        return null;
    }

    public boolean close() {
        boolean success = true;
        try {
            if (this.oos != null) {
                this.oos.writeObject(this.hmap);
                this.oos.flush();
                this.oos.close();
                this.oof.close();
                this.oos = null;
            }
            if (this.iis != null) {
                this.iis.close();
                this.iis = null;
            }
        }
        catch (IOException e) {
            success = false;
        }
        System.gc();
        return success;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

