/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.P1D;
import jplot.GraphLabel;
import jplot.LinePars;

public class HKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String text;
    protected Font font;
    protected Color color;
    protected float transp;
    protected int key_type;
    protected Color key_color;
    protected float key_size;
    protected float key_space;
    protected float key_line_width;
    protected GraphLabel label;
    protected double Xpos;
    protected double Ypos;
    protected int usePosition = 0;
    protected boolean defaultPosition = false;
    protected float ySeparation = 0.06f;
    protected float defaultKeySize = 4.0f;

    public HKey(String s, Font f, Color c) {
        this.text = s;
        this.font = f;
        this.color = c;
        this.transp = 1.0f;
        this.Xpos = 0.0;
        this.Ypos = 0.0;
        this.usePosition = 2;
        this.key_type = 0;
        this.key_color = Color.blue;
        this.key_size = this.defaultKeySize;
        this.key_space = 6.0f;
        this.key_line_width = 2.0f;
        this.label = new GraphLabel(13, s, f, c);
        this.label.setKey(this.key_type, this.key_size, this.key_color);
        this.label.setKeyLineWidth(this.key_line_width);
        this.label.setKeySpace(this.key_space);
        this.ySeparation = 0.05f;
    }

    public HKey(String text, double x, double y, Font font, Color color, String howToSet, Object obj) {
        String name;
        this.text = text;
        this.font = font;
        this.color = color;
        this.transp = 1.0f;
        this.Xpos = x;
        this.Ypos = y;
        this.key_type = 0;
        this.key_color = Color.blue;
        this.key_size = this.defaultKeySize;
        this.key_space = 6.0f;
        this.key_line_width = 2.0f;
        this.setDefaultPosition(false);
        this.usePosition = 2;
        if (howToSet.equalsIgnoreCase("USER")) {
            this.usePosition = 2;
        }
        if (howToSet.equalsIgnoreCase("NDC")) {
            this.usePosition = 1;
            if (x > 1.0) {
                x = 1.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
        }
        if ((name = obj.getClass().getName()).equalsIgnoreCase("jhplot.P1D")) {
            P1D p = (P1D)obj;
            LinePars lp = p.getDrawOption();
            this.key_color = lp.getColor();
            this.key_line_width = lp.getPenWidth();
            if (lp.isDrawSymbol()) {
                this.key_type = lp.getSymbol();
                this.key_size = lp.getSymbolSize() * 0.2f;
                this.key_space = this.key_space + 1.5f * this.defaultKeySize - this.key_size;
            }
            if (lp.isDrawLine()) {
                this.key_type = 30;
                if (lp.getDashLength() > 0.0f) {
                    this.key_type = 31;
                }
                if (lp.getDashLength() > 3.0f) {
                    this.key_type = 32;
                }
            }
        } else if (name.equalsIgnoreCase("jhplot.F1D")) {
            F1D p = (F1D)obj;
            LinePars lp = p.getDrawOption();
            this.key_color = lp.getColor();
            this.key_line_width = lp.getPenWidth();
            this.key_type = 30;
            this.key_size = 6.0f;
            if (lp.getDashLength() > 0.0f) {
                this.key_type = 31;
            }
            if (lp.getDashLength() > 3.0f) {
                this.key_type = 32;
            }
        } else if (name.equalsIgnoreCase("jhplot.H1D")) {
            H1D p = (H1D)obj;
            LinePars lp = p.getDrawOption();
            this.key_color = lp.getColor();
            this.key_line_width = lp.getPenWidth();
            this.key_size = 6.0f;
            if (lp.fill()) {
                this.key_color = lp.getFillColor();
                this.transp = lp.getFillColorTransparency();
                this.key_type = 20;
            } else {
                this.key_type = 21;
            }
        }
        this.label = new GraphLabel(13, text, font, color);
        this.label.setKey(this.key_type, this.key_size, this.key_color);
        this.label.setKeyLineWidth(this.key_line_width);
        this.label.setKeySpace(this.key_space);
    }

    public HKey(String text, double x, double y, Font font, String howToSet, Object obj) {
        this(text, x, y, font, Color.black, howToSet, obj);
    }

    public HKey(String text, double x, double y, String howToSet, Object obj) {
        this(text, x, y, new Font("Arial", 1, 14), Color.black, howToSet, obj);
    }

    public HKey(String text, double x, double y, Object obj) {
        this(text, x, y, new Font("Arial", 1, 14), Color.black, "NDC", obj);
    }

    public HKey(String text, Object obj) {
        this(text, 0.16, 0.82, new Font("Arial", 1, 14), Color.black, "NDC", obj);
        this.setDefaultPosition(true);
    }

    public HKey(String s, Font f) {
        this(s, f, Color.BLACK);
    }

    public HKey(String s) {
        this(s, new Font("Arial", 1, 14), Color.BLACK);
    }

    public HKey(String s, double x, double y) {
        this(s);
        this.usePosition = 2;
        this.Xpos = x;
        this.Ypos = y;
        this.text = s;
    }

    public HKey(String s, double x, double y, String howToSet) {
        this(s);
        this.usePosition = 2;
        if (howToSet.equalsIgnoreCase("USER")) {
            this.usePosition = 2;
        }
        if (howToSet.equalsIgnoreCase("NDC")) {
            this.usePosition = 1;
            if (x > 1.0) {
                x = 1.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
        }
        this.Xpos = x;
        this.Ypos = y;
    }

    public void setText(String s) {
        this.text = s;
        this.label.setText(s);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setColor(Color c) {
        this.label.setColor(c);
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public void setFont(Font f) {
        this.font = f;
        this.label.setFont(f);
    }

    public Font getFont() {
        return this.font;
    }

    public void setRotation(double r) {
        this.label.setRotation(r);
    }

    public double getRotation() {
        return this.label.getRotation();
    }

    public void setLocation(double x, double y) {
        this.usePosition = 2;
        this.Xpos = x;
        this.Ypos = y;
        this.setDefaultPosition(false);
    }

    public void setKey(int key_type, float key_size, Color key_color) {
        this.key_type = key_type;
        this.key_size = key_size;
        this.key_color = key_color;
        this.label.setKey(key_type, key_size, key_color);
    }

    public void setLineWidth(int key_line_width) {
        this.key_line_width = key_line_width;
        this.label.setKeyLineWidth(key_line_width);
    }

    public void setKeySpace(float key_space) {
        this.key_space = key_space;
        this.label.setKeySpace(key_space);
    }

    public double getKeySpace() {
        return this.label.getKeySpace();
    }

    public double getLineWidth() {
        return this.label.getKeyLineWidth();
    }

    public int getKeyType() {
        return this.label.getKeyType();
    }

    public Color getKeyColor() {
        return this.label.getKeyColor();
    }

    public float getKeySize() {
        return this.label.getKeySize();
    }

    public void setLocation(double x, double y, String howToSet) {
        this.usePosition = 2;
        if (howToSet.equalsIgnoreCase("USER")) {
            this.usePosition = 2;
        }
        if (howToSet.equalsIgnoreCase("NDC")) {
            this.usePosition = 1;
            if (x > 1.0) {
                x = 1.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
        }
        this.Xpos = x;
        this.Ypos = y;
        this.setDefaultPosition(false);
    }

    public int getPositionCoordinate() {
        return this.usePosition;
    }

    public double getX() {
        return this.Xpos;
    }

    public double getY() {
        return this.Ypos;
    }

    public GraphLabel getGraphLabel() {
        return this.label;
    }

    public void setSeparation(float y) {
        this.ySeparation = y;
    }

    public float getSeparation() {
        return this.ySeparation;
    }

    public boolean isDefaultPosition() {
        return this.defaultPosition;
    }

    public void setDefaultPosition(boolean isdefault) {
        this.defaultPosition = isdefault;
        if (this.defaultPosition) {
            this.usePosition = 1;
        }
    }
}

