/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IFunction;
import jhplot.DrawOptions;
import jhplot.FProxy;
import jhplot.gui.HelpBrowser;
import jhplot.math.exp4j.Expression;
import jhplot.math.exp4j.ExpressionBuilder;
import jhplot.utils.Util;

public class F3D
extends DrawOptions {
    private static final long serialVersionUID = 1L;
    private FProxy proxy;
    final int maxpoints = 200;
    private String title = "F3D";
    private Expression calc = null;
    private ExpressionBuilder function = null;

    public F3D(String name) {
        this(name, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public F3D(String title, String name, double Xmin, double Xmax, double Ymin, double Ymax, double Zmin, double Zmax) {
        this.proxy = new FProxy(3, title, name, null, new double[]{Xmin, Xmax, Ymin, Ymax, Zmin, Zmax}, 200, true);
        this.function = new ExpressionBuilder(this.proxy.getName());
        try {
            this.calc = this.function.variables("x", "y", "z").build();
        }
        catch (IllegalArgumentException e) {
            this.proxy.setParsed(false);
            Util.ErrorMessage((String)("Failed to parse function " + name + " Error:" + e.toString()));
        }
    }

    public F3D(String name, double Xmin, double Xmax, double Ymin, double Ymax, double Zmin, double Zmax) {
        this(name, name, Xmin, Xmax, Ymin, Ymax, Zmin, Zmax);
    }

    public F3D(String title, String name, IFunction iname, double Xmin, double Xmax, double Ymin, double Ymax, double Zmin, double Zmax) {
        this.proxy = new FProxy(3, title, name, iname, new double[]{Xmin, Xmax, Ymin, Ymax, Zmin, Zmax}, 200, true);
        this.title = title;
    }

    public F3D(String name, IFunction iname, double Xmin, double Xmax, double Ymin, double Ymax, double Zmin, double Zmax) {
    }

    public F3D(FProxy f) {
        if (f.getType() != 3) {
            Util.ErrorMessage((String)("Error in parsing F3D. Wrong function type! " + f.getName()));
            return;
        }
        this.proxy = f;
        this.setTitle(this.proxy.getTitle());
    }

    public F3D(IFunction iname, double Xmin, double Xmax, double Ymin, double Ymax, double Zmin, double Zmax) {
        this("IFunction", iname, Xmin, Xmax, Ymin, Ymax, Zmin, Zmax);
    }

    public double eval(double x, double y, double z) {
        double h = 0.0;
        IFunction iname = this.proxy.getIFunction();
        boolean isParsed = this.proxy.isParsed();
        String name = this.proxy.getName();
        if (!(iname != null || this.function != null && isParsed)) {
            Util.ErrorMessage((String)"eval(): Function was not parsed correctly!");
            return h;
        }
        if (iname == null && this.function != null && isParsed) {
            try {
                this.calc.setVariable("x", x);
                this.calc.setVariable("y", y);
                this.calc.setVariable("z", z);
                h = this.calc.evaluate();
            }
            catch (Exception e) {
                Util.ErrorMessage((String)("Failed to evaluate function " + name + " Error:" + e.toString()));
            }
        }
        if (iname != null && iname.dimension() == 3) {
            try {
                double[] xx = new double[iname.dimension()];
                xx[0] = x;
                xx[1] = y;
                xx[2] = z;
                h = iname.value(xx);
            }
            catch (Exception e) {
                Util.ErrorMessage((String)("Failed to evaluate function " + name + " Error:" + e.toString()));
            }
        }
        return h;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setMinX(double min) {
        this.proxy.setLimit(0, min);
    }

    public double getMinX() {
        double[] d = this.proxy.getLimits();
        return d[0];
    }

    public void setMinY(double min) {
        this.proxy.setLimit(2, min);
    }

    public void setMinZ(double min) {
        this.proxy.setLimit(4, min);
    }

    public double getMinY() {
        double[] d = this.proxy.getLimits();
        return d[2];
    }

    public double getMinZ() {
        double[] d = this.proxy.getLimits();
        return d[4];
    }

    public void setMaxX(double max) {
        this.proxy.setLimit(1, max);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public void setMaxZ(double max) {
        this.proxy.setLimit(5, max);
    }

    public void setName(String name) {
        this.proxy.setName(name);
    }

    public String getName() {
        return this.proxy.getName();
    }

    public double getMaxX() {
        double[] d = this.proxy.getLimits();
        return d[1];
    }

    public double getMaxZ() {
        double[] d = this.proxy.getLimits();
        return d[5];
    }

    public void setMaxY(double max) {
        this.proxy.setLimit(3, max);
    }

    public double getMaxY() {
        double[] d = this.proxy.getLimits();
        return d[1];
    }

    public void setPoints(int bins) {
        this.proxy.setPoints(bins);
    }

    public int getPoints() {
        return this.proxy.getPoints();
    }

    public Expression getParse() {
        return this.calc;
    }

    public boolean parse() {
        boolean isParsed = this.proxy.isParsed();
        String name = this.proxy.getName();
        try {
            this.function = new ExpressionBuilder(name);
            this.calc = this.function.variables("x", "y", "z").build();
            this.proxy.setParsed(true);
        }
        catch (IllegalArgumentException e) {
            this.proxy.setParsed(false);
            Util.ErrorMessage((String)("Failed to parse function " + name + " Error:" + e.toString()));
        }
        return isParsed;
    }

    public IFunction getIFunction() {
        return this.proxy.getIFunction();
    }

    public boolean isParsed() {
        return this.proxy.isParsed();
    }

    public FProxy get() {
        return this.proxy;
    }

    public void setPar(String parameter, double value) {
        String s1 = Double.toString(value);
        String name = this.proxy.getName();
        this.proxy.setName(name.replaceAll(parameter, s1));
    }

    public String toString() {
        String tmp = "F3D:" + this.proxy.getName();
        double[] d = this.proxy.getLimits();
        boolean isParsed = this.proxy.isParsed();
        double Xmin = d[0];
        double Xmax = d[1];
        double Ymin = d[2];
        double Ymax = d[3];
        double Zmin = d[2];
        double Zmax = d[3];
        int points = this.proxy.getPoints();
        tmp = tmp + " (title=" + this.getTitle() + ", n=" + Integer.toString(points) + ", minX=" + Double.toString(Xmin) + ", maxX=" + Double.toString(Xmax) + ", minY=" + Double.toString(Ymin) + ", maxY=" + Double.toString(Ymax) + ", " + Double.toString(Xmax) + ", minZ=" + Double.toString(Zmin) + ", maxZ=" + Double.toString(Zmax) + ", " + Boolean.toString(isParsed) + ")";
        return tmp;
    }
}

