/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IFunction;
import jhplot.DrawOptions;
import jhplot.FProxy;
import jhplot.H2D;
import jhplot.gui.HelpBrowser;
import jhplot.math.Numeric;
import jhplot.math.exp4j.Expression;
import jhplot.math.exp4j.ExpressionBuilder;
import jhplot.utils.Util;

public class F2D
extends DrawOptions {
    private static final long serialVersionUID = 1L;
    private Expression calc = null;
    private ExpressionBuilder function = null;
    final int maxpoints = 200;
    private FProxy proxy;
    private String lastException = "";

    public F2D(String name) {
        this(name, name, 0.0, 0.0, 0.0, 0.0);
    }

    public F2D(String title, String name) {
        this(title, name, 0.0, 1.0, 0.0, 1.0);
    }

    public F2D(String title, String name, double Xmin, double Xmax, double Ymin, double Ymax) {
        this.is3D = true;
        this.proxy = new FProxy(2, title, name, null, new double[]{Xmin, Xmax, Ymin, Ymax, 0.0, 0.0}, 200, true);
        this.setTitle(title);
        this.function = new ExpressionBuilder(this.proxy.getName());
        try {
            this.function.variables("x", "y");
            this.calc = this.function.build();
        }
        catch (IllegalArgumentException e) {
            this.proxy.setParsed(false);
            Util.ErrorMessage((String)("Failed to parse function " + name + " Error:" + e.toString()));
        }
    }

    public F2D(String name, double Xmin, double Xmax, double Ymin, double Ymax) {
        this(name, name, Xmin, Xmax, Ymin, Ymax);
    }

    public F2D(String title, IFunction iname, double Xmin, double Xmax, double Ymin, double Ymax) {
        this.proxy = new FProxy(2, title, title, iname, new double[]{Xmin, Xmax, Ymin, Ymax, 0.0, 0.0}, 200, false);
        this.setTitle(title);
    }

    public F2D(String title, Expression calc, double Xmin, double Xmax, double Ymin, double Ymax) {
        this.proxy = new FProxy(1, title, title, null, new double[]{Xmin, Xmax, Ymin, Ymax, 0.0, 0.0}, 200, true);
        this.calc = calc;
        this.setTitle(title);
    }

    public F2D(Expression calc, double Xmin, double Xmax, double Ymin, double Ymax) {
        this("F2D", calc, Xmin, Xmax, Ymin, Ymax);
    }

    public F2D(IFunction iname) {
        this("IFunction", iname, 0.0, 0.0, 0.0, 10.0);
    }

    public F2D(FProxy f) {
        if (f.getType() != 2) {
            Util.ErrorMessage((String)("Error in parsing F2D. Wrong function type! " + f.getName()));
            return;
        }
        this.proxy = f;
        this.setTitle(this.proxy.getTitle());
    }

    public F2D(IFunction iname, double Xmin, double Xmax, double Ymin, double Ymax) {
        this(iname.title(), iname, Xmin, Xmax, Ymin, Ymax);
    }

    public double eval(double x, double y) {
        double z = 0.0;
        IFunction iname = this.proxy.getIFunction();
        boolean isParsed = this.proxy.isParsed();
        String name = this.proxy.getName();
        if (!(iname != null || this.calc != null && isParsed)) {
            Util.ErrorMessage((String)"eval(x,y): Function was not parsed correctly!");
            return z;
        }
        if (iname == null && this.calc != null && isParsed) {
            try {
                this.calc.setVariable("x", x);
                this.calc.setVariable("y", y);
                z = this.calc.evaluate();
            }
            catch (Exception e) {
                String ss1 = Double.toString(x);
                String ss2 = Double.toString(y);
                System.err.println("Failed to evaluate " + name + " at position=(" + ss1 + "," + ss2 + ")");
                return Double.MAX_VALUE;
            }
        }
        if (iname != null && iname.dimension() == 2) {
            try {
                double[] xx = new double[iname.dimension()];
                xx[0] = x;
                xx[1] = y;
                z = iname.value(xx);
            }
            catch (Exception e) {
                String ss1 = Double.toString(x);
                String ss2 = Double.toString(y);
                System.err.println("Failed to evaluate " + name + " at position=(" + ss1 + "," + ss2 + ")");
                return Double.MAX_VALUE;
            }
        }
        return z;
    }

    public IFunction getIFunction() {
        return this.proxy.getIFunction();
    }

    public double[][] eval(double[] x, double[] y) {
        String ss2;
        String ss1;
        int j;
        int i;
        IFunction iname = this.proxy.getIFunction();
        boolean isParsed = this.proxy.isParsed();
        String name = this.proxy.getName();
        double[][] z = new double[x.length][y.length];
        String err = "";
        if (!(iname != null || this.calc != null && isParsed)) {
            Util.ErrorMessage((String)"eval(x[],y[]): Function was not parsed correctly!");
            return z;
        }
        if (iname == null && this.calc != null && isParsed) {
            block4: for (i = 0; i < x.length; ++i) {
                for (j = 0; j < y.length; ++j) {
                    try {
                        this.calc.setVariable("x", x[i]);
                        this.calc.setVariable("y", y[i]);
                        z[i][j] = this.calc.evaluate();
                        continue;
                    }
                    catch (Exception e) {
                        ss1 = Double.toString(x[i]);
                        ss2 = Double.toString(y[j]);
                        err = "Failed to evaluate " + name + " at position=(" + ss1 + "," + ss2 + ")";
                        continue block4;
                    }
                }
            }
        }
        if (iname != null) {
            block6: for (i = 0; i < x.length; ++i) {
                for (j = 0; j < y.length; ++j) {
                    try {
                        double[] xx = new double[iname.dimension()];
                        xx[0] = x[i];
                        xx[1] = y[j];
                        z[i][j] = iname.value(xx);
                        continue;
                    }
                    catch (Exception e) {
                        ss1 = Double.toString(x[i]);
                        ss2 = Double.toString(y[j]);
                        err = "Failed to evaluate AIDA function " + name + " at position=(" + ss1 + "," + ss2 + ")";
                        continue block6;
                    }
                }
            }
        }
        if (err.length() > 1) {
            Util.ErrorMessage((String)err);
            return z;
        }
        return z;
    }

    public void setMinX(double min) {
        this.proxy.setLimit(0, min);
    }

    public boolean parse() {
        boolean isParsed = this.proxy.isParsed();
        String name = this.proxy.getName();
        try {
            this.function = new ExpressionBuilder(name);
            this.calc = this.function.variables("x", "y").build();
            isParsed = true;
        }
        catch (IllegalArgumentException e) {
            isParsed = false;
            Util.ErrorMessage((String)("Failed to parse function " + name + " Error:" + e.toString()));
        }
        return isParsed;
    }

    public double getMinX() {
        double[] d = this.proxy.getLimits();
        return d[0];
    }

    public void setMinY(double min) {
        this.proxy.setLimit(2, min);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public double getMinY() {
        double[] d = this.proxy.getLimits();
        return d[2];
    }

    public void setMaxX(double max) {
        this.proxy.setLimit(1, max);
    }

    public void setName(String name) {
        this.proxy.setName(name);
    }

    public String getName() {
        return this.proxy.getName();
    }

    public double getMaxX() {
        double[] d = this.proxy.getLimits();
        return d[1];
    }

    public void setMaxY(double max) {
        this.proxy.setLimit(1, max);
    }

    public double getMaxY() {
        double[] d = this.proxy.getLimits();
        return d[3];
    }

    public void setPoints(int bins) {
        this.proxy.setPoints(bins);
    }

    public void setPar(String parameter, double value) {
        String s1 = Double.toString(value);
        String name = this.proxy.getName();
        this.proxy.setName(name.replaceAll(parameter, s1));
    }

    public int getPoints() {
        return this.proxy.getPoints();
    }

    public double integral(int N, double minX, double maxX, double minY, double maxY) {
        return Numeric.trapezium2D(N, this, minX, maxX, minY, maxY);
    }

    public double integral(double minX, double maxX, double minY, double maxY) {
        int points = this.proxy.getPoints();
        return this.integral(points, minX, maxX, minY, maxY);
    }

    public boolean simplify() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).simplify().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public String getException() {
        return this.lastException;
    }

    public Expression getParse() {
        return this.calc;
    }

    public H2D getH2D(String hname, int hbinX, double hminX, double hmaxX, int hbinY, double hminY, double hmaxY) {
        int i;
        double dX = (hmaxX - hminX) / (double)hbinX;
        double dY = (hmaxY - hminY) / (double)hbinY;
        double[] xx = new double[hbinX];
        double[] yy = new double[hbinY];
        for (i = 0; i < hbinX; ++i) {
            xx[i] = hminX + (double)i * dX + 0.5 * dX;
        }
        for (i = 0; i < hbinY; ++i) {
            yy[i] = hminY + (double)i * dY + 0.5 * dY;
        }
        double[][] zz = this.eval(xx, yy);
        int ibinsX = hbinX + 2;
        int ibinsY = hbinY + 2;
        double[][] newHeights = new double[ibinsX][ibinsY];
        double[][] newErrors = new double[ibinsX][ibinsY];
        double[][] newMeansX = new double[ibinsX][ibinsY];
        double[][] newRmssX = new double[ibinsX][ibinsY];
        double[][] newMeansY = new double[ibinsX][ibinsY];
        double[][] newRmssY = new double[ibinsX][ibinsY];
        int[][] newEntries = new int[ibinsX][ibinsY];
        newHeights[0][0] = 0.0;
        newHeights[ibinsX - 1][ibinsY - 1] = 0.0;
        int n = 0;
        for (int i2 = 0; i2 < hbinX; ++i2) {
            for (int j = 0; j < hbinY; ++j) {
                int i1 = i2 + 2;
                int j1 = j + 2;
                newHeights[i1][j1] = zz[i2][j];
                newErrors[i1][j1] = 0.0;
                newEntries[i1][j1] = (int)zz[i2][j];
                newMeansX[i1][j1] = zz[i2][j];
                newRmssX[i1][j1] = 0.0;
                newMeansY[i1][j1] = zz[i2][j];
                newRmssY[i1][j1] = 0.0;
                n += (int)zz[i2][j];
            }
        }
        H2D hnew = new H2D(hname, hbinX, hminX, hmaxX, hbinY, hminY, hmaxY);
        hnew.setContents(newHeights, newErrors, newEntries, newMeansX, newMeansY, newRmssX, newRmssY);
        hnew.setMeanX(0.0);
        hnew.setMeanY(0.0);
        hnew.setRmsX(0.0);
        hnew.setRmsY(0.0);
        hnew.setNEntries(n);
        return hnew;
    }

    public double integral() {
        double[] d = this.proxy.getLimits();
        double Xmin = d[0];
        double Xmax = d[1];
        double Ymin = d[2];
        double Ymax = d[3];
        int points = this.proxy.getPoints();
        return this.integral(points, points, Xmin, Xmax, Ymin, Ymax);
    }

    public double integral(int xSegs, int ySegs, double minX, double maxX, double minY, double maxY) {
        double xSegSize = (maxX - minX) / (double)xSegs;
        double ySegSize = (maxY - minY) / (double)ySegs;
        double volume = 0.0;
        for (int i = 0; i < xSegs; ++i) {
            for (int j = 0; j < ySegs; ++j) {
                double height = this.eval(minX + xSegSize * (double)i, minY + ySegSize * (double)j);
                height += this.eval(minX + xSegSize * (double)(i + 1), minY + ySegSize * (double)j);
                height += this.eval(minX + xSegSize * (double)(i + 1), minY + ySegSize * (double)(j + 1));
                height += this.eval(minX + xSegSize * (double)i, minY + ySegSize * (double)(j + 1));
                volume += xSegSize * ySegSize * (height /= 4.0);
            }
        }
        return volume;
    }

    public boolean isParsed() {
        return this.proxy.isParsed();
    }

    public String toMathML() {
        try {
            return jscl.math.Expression.valueOf((String)this.proxy.getName()).toMathML();
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return "";
        }
    }

    public String toJava() {
        try {
            return jscl.math.Expression.valueOf((String)this.proxy.getName()).toJava();
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return "";
        }
    }

    public boolean elementary() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).elementary().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public boolean expand() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).expand().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public boolean factorize() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).factorize().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public boolean numeric() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).numeric().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public FProxy get() {
        return this.proxy;
    }

    public String toString() {
        String tmp = "F2D:" + this.proxy.getName();
        double[] d = this.proxy.getLimits();
        boolean isParsed = this.proxy.isParsed();
        double Xmin = d[0];
        double Xmax = d[1];
        double Ymin = d[2];
        double Ymax = d[3];
        int points = this.proxy.getPoints();
        tmp = tmp + " (title=" + this.getTitle() + ", n=" + Integer.toString(points) + ", minX=" + Double.toString(Xmin) + ", maxX=" + Double.toString(Xmax) + ", minY=" + Double.toString(Ymin) + ", maxY=" + Double.toString(Ymax) + ", " + Boolean.toString(isParsed) + ")";
        return tmp;
    }
}

